// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: service.vdl
package io.v.v23.services.syncbase;

/**
 * SyncgroupManager is the interface for syncgroup operations.
 * TODO(hpucha): Add blessings to create/join and add a refresh method.
 */
public interface SyncgroupManagerClient {

  /**
   * ListSyncgroups returns the relative syncgroup ids of all syncgroups attached to
   * this database.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.util.List<io.v.v23.services.syncbase.Id>>
      listSyncgroups(io.v.v23.context.VContext context);

  /**
   * ListSyncgroups returns the relative syncgroup ids of all syncgroups attached to
   * this database.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.util.List<io.v.v23.services.syncbase.Id>>
      listSyncgroups(io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * ListSyncgroups returns the relative syncgroup ids of all syncgroups attached to
   * this database.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.util.List<io.v.v23.services.syncbase.Id>>
      listSyncgroups(io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * CreateSyncgroup creates a new syncgroup with the given spec.
   *<p>
   * Requires: Client must have at least Read access on the Database; all
   * Collections specified in prefixes must exist; Client must have at least
   * Read access on each of the Collection ACLs.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> createSyncgroup(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo);

  /**
   * CreateSyncgroup creates a new syncgroup with the given spec.
   *<p>
   * Requires: Client must have at least Read access on the Database; all
   * Collections specified in prefixes must exist; Client must have at least
   * Read access on each of the Collection ACLs.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> createSyncgroup(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo,
      io.v.v23.Options opts);

  /**
   * CreateSyncgroup creates a new syncgroup with the given spec.
   *<p>
   * Requires: Client must have at least Read access on the Database; all
   * Collections specified in prefixes must exist; Client must have at least
   * Read access on each of the Collection ACLs.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> createSyncgroup(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo,
      io.v.v23.options.RpcOptions opts);

  /**
   * JoinSyncgroup joins the syncgroup.
   *<p>
   * Requires: Client must have at least Read access on the Database and on the
   * syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.SyncgroupSpec>
      joinSyncgroup(
          io.v.v23.context.VContext context,
          final java.lang.String remoteSyncbaseName,
          final java.util.List<java.lang.String> expectedSyncbaseBlessings,
          final io.v.v23.services.syncbase.Id sgId,
          final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo);

  /**
   * JoinSyncgroup joins the syncgroup.
   *<p>
   * Requires: Client must have at least Read access on the Database and on the
   * syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.SyncgroupSpec>
      joinSyncgroup(
          io.v.v23.context.VContext context,
          final java.lang.String remoteSyncbaseName,
          final java.util.List<java.lang.String> expectedSyncbaseBlessings,
          final io.v.v23.services.syncbase.Id sgId,
          final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo,
          io.v.v23.Options opts);

  /**
   * JoinSyncgroup joins the syncgroup.
   *<p>
   * Requires: Client must have at least Read access on the Database and on the
   * syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.SyncgroupSpec>
      joinSyncgroup(
          io.v.v23.context.VContext context,
          final java.lang.String remoteSyncbaseName,
          final java.util.List<java.lang.String> expectedSyncbaseBlessings,
          final io.v.v23.services.syncbase.Id sgId,
          final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo,
          io.v.v23.options.RpcOptions opts);

  /**
   * LeaveSyncgroup leaves the syncgroup. Previously synced data will continue
   * to be available.
   *<p>
   * Requires: Client must have at least Read access on the Database.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> leaveSyncgroup(
      io.v.v23.context.VContext context, final io.v.v23.services.syncbase.Id sgId);

  /**
   * LeaveSyncgroup leaves the syncgroup. Previously synced data will continue
   * to be available.
   *<p>
   * Requires: Client must have at least Read access on the Database.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> leaveSyncgroup(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.Id sgId,
      io.v.v23.Options opts);

  /**
   * LeaveSyncgroup leaves the syncgroup. Previously synced data will continue
   * to be available.
   *<p>
   * Requires: Client must have at least Read access on the Database.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> leaveSyncgroup(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.Id sgId,
      io.v.v23.options.RpcOptions opts);

  /**
   * DestroySyncgroup destroys the syncgroup. Previously synced data will
   * continue to be available to all members.
   *<p>
   * Requires: Client must have at least Read access on the Database, and must
   * have Admin access on the syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroySyncgroup(
      io.v.v23.context.VContext context, final io.v.v23.services.syncbase.Id sgId);

  /**
   * DestroySyncgroup destroys the syncgroup. Previously synced data will
   * continue to be available to all members.
   *<p>
   * Requires: Client must have at least Read access on the Database, and must
   * have Admin access on the syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroySyncgroup(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.Id sgId,
      io.v.v23.Options opts);

  /**
   * DestroySyncgroup destroys the syncgroup. Previously synced data will
   * continue to be available to all members.
   *<p>
   * Requires: Client must have at least Read access on the Database, and must
   * have Admin access on the syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroySyncgroup(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.Id sgId,
      io.v.v23.options.RpcOptions opts);

  /**
   * EjectFromSyncgroup ejects a member from the syncgroup. The ejected member
   * will not be able to sync further, but will retain any data it has already
   * synced.
   *<p>
   * Requires: Client must have at least Read access on the Database, and must
   * have Admin access on the syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> ejectFromSyncgroup(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.Id sgId,
      final java.lang.String member);

  /**
   * EjectFromSyncgroup ejects a member from the syncgroup. The ejected member
   * will not be able to sync further, but will retain any data it has already
   * synced.
   *<p>
   * Requires: Client must have at least Read access on the Database, and must
   * have Admin access on the syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> ejectFromSyncgroup(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.Id sgId,
      final java.lang.String member,
      io.v.v23.Options opts);

  /**
   * EjectFromSyncgroup ejects a member from the syncgroup. The ejected member
   * will not be able to sync further, but will retain any data it has already
   * synced.
   *<p>
   * Requires: Client must have at least Read access on the Database, and must
   * have Admin access on the syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> ejectFromSyncgroup(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.Id sgId,
      final java.lang.String member,
      io.v.v23.options.RpcOptions opts);

  /**
   * Multi-return value for method {@link #getSyncgroupSpec}.
   */
  @io.v.v23.vdl.MultiReturn
  public static class GetSyncgroupSpecOut {

    public io.v.v23.services.syncbase.SyncgroupSpec spec;

    public java.lang.String version;
  }

  /**
   * GetSyncgroupSpec gets the syncgroup spec. version allows for atomic
   * read-modify-write of the spec - see comment for SetSyncgroupSpec.
   *<p>
   * Requires: Client must have at least Read access on the Database and on the
   * syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupManagerClient.GetSyncgroupSpecOut>
      getSyncgroupSpec(io.v.v23.context.VContext context, final io.v.v23.services.syncbase.Id sgId);

  /**
   * GetSyncgroupSpec gets the syncgroup spec. version allows for atomic
   * read-modify-write of the spec - see comment for SetSyncgroupSpec.
   *<p>
   * Requires: Client must have at least Read access on the Database and on the
   * syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupManagerClient.GetSyncgroupSpecOut>
      getSyncgroupSpec(
          io.v.v23.context.VContext context,
          final io.v.v23.services.syncbase.Id sgId,
          io.v.v23.Options opts);

  /**
   * GetSyncgroupSpec gets the syncgroup spec. version allows for atomic
   * read-modify-write of the spec - see comment for SetSyncgroupSpec.
   *<p>
   * Requires: Client must have at least Read access on the Database and on the
   * syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupManagerClient.GetSyncgroupSpecOut>
      getSyncgroupSpec(
          io.v.v23.context.VContext context,
          final io.v.v23.services.syncbase.Id sgId,
          io.v.v23.options.RpcOptions opts);

  /**
   * SetSyncgroupSpec sets the syncgroup spec. version may be either empty or
   * the value from a previous Get. If not empty, Set will only succeed if the
   * current version matches the specified one.
   *<p>
   * Requires: Client must have at least Read access on the Database, and must
   * have Admin access on the syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSyncgroupSpec(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final java.lang.String version);

  /**
   * SetSyncgroupSpec sets the syncgroup spec. version may be either empty or
   * the value from a previous Get. If not empty, Set will only succeed if the
   * current version matches the specified one.
   *<p>
   * Requires: Client must have at least Read access on the Database, and must
   * have Admin access on the syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSyncgroupSpec(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final java.lang.String version,
      io.v.v23.Options opts);

  /**
   * SetSyncgroupSpec sets the syncgroup spec. version may be either empty or
   * the value from a previous Get. If not empty, Set will only succeed if the
   * current version matches the specified one.
   *<p>
   * Requires: Client must have at least Read access on the Database, and must
   * have Admin access on the syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSyncgroupSpec(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final java.lang.String version,
      io.v.v23.options.RpcOptions opts);

  /**
   * GetSyncgroupMembers gets the info objects for members of the syncgroup.
   *<p>
   * Requires: Client must have at least Read access on the Database and on the
   * syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>>
      getSyncgroupMembers(
          io.v.v23.context.VContext context, final io.v.v23.services.syncbase.Id sgId);

  /**
   * GetSyncgroupMembers gets the info objects for members of the syncgroup.
   *<p>
   * Requires: Client must have at least Read access on the Database and on the
   * syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>>
      getSyncgroupMembers(
          io.v.v23.context.VContext context,
          final io.v.v23.services.syncbase.Id sgId,
          io.v.v23.Options opts);

  /**
   * GetSyncgroupMembers gets the info objects for members of the syncgroup.
   *<p>
   * Requires: Client must have at least Read access on the Database and on the
   * syncgroup ACL.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>>
      getSyncgroupMembers(
          io.v.v23.context.VContext context,
          final io.v.v23.services.syncbase.Id sgId,
          io.v.v23.options.RpcOptions opts);
}
