// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

/**
 * StoreChangeCollectionInfo represents collection metadata in a StoreChange.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.StoreChangeCollectionInfo")
public class StoreChangeCollectionInfo extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Allowed", index = 0)
  private java.util.Set<io.v.v23.security.access.Tag> allowed;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Perms", index = 1)
  private io.v.v23.security.access.Permissions perms;

  /**
   * Vdl type for {@link StoreChangeCollectionInfo}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(StoreChangeCollectionInfo.class);

  /**
   * Creates a new zero-value instance of {@link StoreChangeCollectionInfo}.
   */
  public StoreChangeCollectionInfo() {
    super(VDL_TYPE);

    this.allowed = new java.util.HashSet<io.v.v23.security.access.Tag>();

    this.perms = new io.v.v23.security.access.Permissions();
  }

  /**
   * Creates a new instance of {@link StoreChangeCollectionInfo} with the provided field values.
   */
  public StoreChangeCollectionInfo(
      java.util.Set<io.v.v23.security.access.Tag> allowed,
      io.v.v23.security.access.Permissions perms) {
    super(VDL_TYPE);

    this.allowed = allowed;

    this.perms = perms;
  }

  /**
   * Allowed lists all permissions that the client has on the collection. It is
   * separate from Perms to allow clients lacking Admin permission, who are not
   * allowed to read the full Perms, to find out what permissions they have on
   * the Collection. If the client has no Read permission (Allowed does not
   * contain Read), row updates on that collection will be silently skipped.
   * TODO(ivanpi): Row updates are currently checked against the most recently
   * committed collection permissions, which may be out of sync with the last
   * seen permissions on the watch stream (that were in effect when the row was
   * written). This can result in the watch stream skipping or failing to skip
   * rows if Read access has changed. Destroying the collection may also result
   * in skipped rows since there are no permissions to check against.
   */
  public java.util.Set<io.v.v23.security.access.Tag> getAllowed() {
    return this.allowed;
  }

  /**
   * Allowed lists all permissions that the client has on the collection. It is
   * separate from Perms to allow clients lacking Admin permission, who are not
   * allowed to read the full Perms, to find out what permissions they have on
   * the Collection. If the client has no Read permission (Allowed does not
   * contain Read), row updates on that collection will be silently skipped.
   * TODO(ivanpi): Row updates are currently checked against the most recently
   * committed collection permissions, which may be out of sync with the last
   * seen permissions on the watch stream (that were in effect when the row was
   * written). This can result in the watch stream skipping or failing to skip
   * rows if Read access has changed. Destroying the collection may also result
   * in skipped rows since there are no permissions to check against.
   */
  public void setAllowed(java.util.Set<io.v.v23.security.access.Tag> allowed) {
    this.allowed = allowed;
  }

  /**
   * Perms contains the full collection permissions only if the client has Admin
   * permissions on the collection (Allowed contains Admin). Otherwise, Perms is
   * nil.
   * TODO(ivanpi): Update when Admin tag is split into AdminRead and AdminWrite.
   */
  public io.v.v23.security.access.Permissions getPerms() {
    return this.perms;
  }

  /**
   * Perms contains the full collection permissions only if the client has Admin
   * permissions on the collection (Allowed contains Admin). Otherwise, Perms is
   * nil.
   * TODO(ivanpi): Update when Admin tag is split into AdminRead and AdminWrite.
   */
  public void setPerms(io.v.v23.security.access.Permissions perms) {
    this.perms = perms;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    StoreChangeCollectionInfo other = (StoreChangeCollectionInfo) obj;

    if (this.allowed == null) {
      if (other.allowed != null) {
        return false;
      }
    } else if (!this.allowed.equals(other.allowed)) {
      return false;
    }

    if (this.perms == null) {
      if (other.perms != null) {
        return false;
      }
    } else if (!this.perms.equals(other.perms)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.allowed == null ? 0 : this.allowed.hashCode());

    result = prime * result + (this.perms == null ? 0 : this.perms.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "allowed:" + this.allowed;

    result += ", ";

    result += "perms:" + this.perms;

    return result + "}";
  }
}
