// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

/**
 * StoreChange is the new value for a watched entity.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.StoreChange")
public class StoreChange extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Value", index = 0)
  private io.v.v23.vdl.VdlAny value;

  @io.v.v23.vdl.GeneratedFromVdl(name = "FromSync", index = 1)
  private boolean fromSync;

  /**
   * Vdl type for {@link StoreChange}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(StoreChange.class);

  /**
   * Creates a new zero-value instance of {@link StoreChange}.
   */
  public StoreChange() {
    super(VDL_TYPE);

    this.value = new io.v.v23.vdl.VdlAny();

    this.fromSync = false;
  }

  /**
   * Creates a new instance of {@link StoreChange} with the provided field values.
   */
  public StoreChange(io.v.v23.vdl.VdlAny value, boolean fromSync) {
    super(VDL_TYPE);

    this.value = value;

    this.fromSync = fromSync;
  }

  /**
   * Value is the new value for the entity if the Change state equals to Exists,
   * otherwise the Value is nil. The Value type is determined by the entity
   * type:
   * - for row updates, Value is the actual row value.
   * - for collection updates, Value is a StoreChangeCollectionInfo.
   * - for the initial root entity update, Value is nil.
   */
  public io.v.v23.vdl.VdlAny getValue() {
    return this.value;
  }

  /**
   * Value is the new value for the entity if the Change state equals to Exists,
   * otherwise the Value is nil. The Value type is determined by the entity
   * type:
   * - for row updates, Value is the actual row value.
   * - for collection updates, Value is a StoreChangeCollectionInfo.
   * - for the initial root entity update, Value is nil.
   */
  public void setValue(io.v.v23.vdl.VdlAny value) {
    this.value = value;
  }

  /**
   * FromSync indicates whether the change came from sync. If FromSync is
   * false, then the change originated from the local device.
   * Note: FromSync is always false for initial state Changes.
   */
  public boolean getFromSync() {
    return this.fromSync;
  }

  /**
   * FromSync indicates whether the change came from sync. If FromSync is
   * false, then the change originated from the local device.
   * Note: FromSync is always false for initial state Changes.
   */
  public void setFromSync(boolean fromSync) {
    this.fromSync = fromSync;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    StoreChange other = (StoreChange) obj;

    if (this.value == null) {
      if (other.value != null) {
        return false;
      }
    } else if (!this.value.equals(other.value)) {
      return false;
    }

    if (this.fromSync != other.fromSync) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.value == null ? 0 : this.value.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.fromSync).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "value:" + this.value;

    result += ", ";

    result += "fromSync:" + this.fromSync;

    return result + "}";
  }
}
