// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.v23.services.syncbase;

/**
 * Wrapper for {@link ServiceServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class ServiceServerWrapper {
  private final io.v.v23.services.syncbase.ServiceServer server;

  private final io.v.v23.services.permissions.ObjectServerWrapper wrapperObject;

  /**
   * Creates a new {@link ServiceServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public ServiceServerWrapper(io.v.v23.services.syncbase.ServiceServer server) {
    this.server = server;

    this.wrapperObject = new io.v.v23.services.permissions.ObjectServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  io.v.v23.services.syncbase.DevModeUpdateVClockOpts.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "devModeUpdateVClock",
              "// DevModeUpdateVClock updates various bits of Syncbase virtual clock and"
                  + "// clock daemon state based on the specified options."
                  + "// Requires --dev flag to be set (in addition to Admin check)."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(org.joda.time.DateTime.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "devModeGetTime",
              "// DevModeGetTime returns the current time per the Syncbase clock."
                  + "// Requires --dev flag to be set (in addition to Admin check)."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Service",
        "io.v.v23.services.syncbase",
        "// Service represents a Vanadium Syncbase service."
            + "// Service.Glob operates over Database ids."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("devModeGetTime".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"devModeGetTime\": %s", e.getMessage()));
      }
    }

    if ("devModeUpdateVClock".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format(
                "Couldn't get tags for method \"devModeUpdateVClock\": %s", e.getMessage()));
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperObject.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  /**
   * DevModeUpdateVClock updates various bits of Syncbase virtual clock and
   * clock daemon state based on the specified options.
   * Requires --dev flag to be set (in addition to Admin check).
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> devModeUpdateVClock(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.DevModeUpdateVClockOpts uco) {

    return this.server.devModeUpdateVClock(_ctx, _call, uco);
  }

  /**
   * DevModeGetTime returns the current time per the Syncbase clock.
   * Requires --dev flag to be set (in addition to Admin check).
   */
  public com.google.common.util.concurrent.ListenableFuture<org.joda.time.DateTime> devModeGetTime(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.devModeGetTime(_ctx, _call);
  }

  /**
   * GetPermissions returns the complete, current Permissions for an object. The
   * returned version can be passed to a subsequent call to SetPermissions for
   * optimistic concurrency control. A successful call to SetPermissions will
   * invalidate version, and the client must call GetPermissions again to get
   * the current version.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectServer.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
          throws io.v.v23.verror.VException {

    return this.wrapperObject.getPermissions(ctx, call);
  }

  /**
   * SetPermissions replaces the current Permissions for an object.  version
   * allows for optional, optimistic concurrency control.  If non-empty,
   * version's value must come from GetPermissions.  If any client has
   * successfully called SetPermissions in the meantime, the version will be
   * stale and SetPermissions will fail.  If empty, SetPermissions performs an
   * unconditional update.
   *<p>
   * Permissions objects are expected to be small.  It is up to the
   * implementation to define the exact limit, though it should probably be
   * around 100KB.  Large lists of principals can be represented concisely using
   * blessings.
   *<p>
   * There is some ambiguity when calling SetPermissions on a mount point.
   * Does it affect the mount itself or does it affect the service endpoint
   * that the mount points to?  The chosen behavior is that it affects the
   * service endpoint.  To modify the mount point's Permissions, use
   * ResolveToMountTable to get an endpoint and call SetPermissions on that.
   * This means that clients must know when a name refers to a mount point to
   * change its Permissions.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version)
      throws io.v.v23.verror.VException {

    return this.wrapperObject.setPermissions(ctx, call, perms, version);
  }
}
