// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.v23.services.syncbase;

/**
 * Implementation of the {@link ServiceClient} interface.
 */
final class ServiceClientImpl implements io.v.v23.services.syncbase.ServiceClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  private final io.v.v23.services.permissions.ObjectClient implObject;

  /**
   * Creates a new instance of {@link ServiceClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public ServiceClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implObject =
          io.v.v23.services.permissions.ObjectClientFactory.getObjectClient(vName, opts);
    }
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface ServiceClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> devModeUpdateVClock(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.DevModeUpdateVClockOpts uco) {
    return devModeUpdateVClock(_context, uco, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> devModeUpdateVClock(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.DevModeUpdateVClockOpts uco,
      io.v.v23.Options _opts) {
    return devModeUpdateVClock(_context, uco, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> devModeUpdateVClock(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.DevModeUpdateVClockOpts uco,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {uco};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.syncbase.DevModeUpdateVClockOpts.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "devModeUpdateVClock", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<org.joda.time.DateTime> devModeGetTime(
      io.v.v23.context.VContext _context) {
    return devModeGetTime(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<org.joda.time.DateTime> devModeGetTime(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return devModeGetTime(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<org.joda.time.DateTime> devModeGetTime(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "devModeGetTime", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, org.joda.time.DateTime>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<org.joda.time.DateTime>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      org.joda.time.DateTime.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], org.joda.time.DateTime>() {
                      @Override
                      public org.joda.time.DateTime apply(Object[] _results) {

                        return (org.joda.time.DateTime) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context) {

    return this.implObject.getPermissions(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implObject.getPermissions(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implObject.getPermissions(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version) {

    return this.implObject.setPermissions(_context, perms, version);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version,
      io.v.v23.Options _opts) {

    return this.implObject.setPermissions(_context, perms, version, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version,
      io.v.v23.options.RpcOptions _opts) {

    return this.implObject.setPermissions(_context, perms, version, _opts);
  }
}
