// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

/**
 * SchemaMetadata maintains metadata related to the schema of a given database.
 * There is one SchemaMetadata per database.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.SchemaMetadata")
public class SchemaMetadata extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Version", index = 0)
  private int version;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Policy", index = 1)
  private io.v.v23.services.syncbase.CrPolicy policy;

  /**
   * Vdl type for {@link SchemaMetadata}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(SchemaMetadata.class);

  /**
   * Creates a new zero-value instance of {@link SchemaMetadata}.
   */
  public SchemaMetadata() {
    super(VDL_TYPE);

    this.version = 0;

    this.policy = new io.v.v23.services.syncbase.CrPolicy();
  }

  /**
   * Creates a new instance of {@link SchemaMetadata} with the provided field values.
   */
  public SchemaMetadata(int version, io.v.v23.services.syncbase.CrPolicy policy) {
    super(VDL_TYPE);

    this.version = version;

    this.policy = policy;
  }

  /**
   * Non negative Schema version number. Should be increased with every schema
   * change (e.g. adding fields to structs) that cannot be handled by previous
   * versions of the app.
   * TODO(jlodhia,ivanpi): Deprecated, needs update to multiple parallel version
   * semantics.
   */
  public int getVersion() {
    return this.version;
  }

  /**
   * Non negative Schema version number. Should be increased with every schema
   * change (e.g. adding fields to structs) that cannot be handled by previous
   * versions of the app.
   * TODO(jlodhia,ivanpi): Deprecated, needs update to multiple parallel version
   * semantics.
   */
  public void setVersion(int version) {
    this.version = version;
  }

  public io.v.v23.services.syncbase.CrPolicy getPolicy() {
    return this.policy;
  }

  public void setPolicy(io.v.v23.services.syncbase.CrPolicy policy) {
    this.policy = policy;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    SchemaMetadata other = (SchemaMetadata) obj;

    if (this.version != other.version) {
      return false;
    }

    if (this.policy == null) {
      if (other.policy != null) {
        return false;
      }
    } else if (!this.policy.equals(other.policy)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + this.version;

    result = prime * result + (this.policy == null ? 0 : this.policy.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "version:" + this.version;

    result += ", ";

    result += "policy:" + this.policy;

    return result + "}";
  }
}
