// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.v23.services.syncbase;

/**
 * Wrapper for {@link SchemaManagerServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class SchemaManagerServerWrapper {
  private final io.v.v23.services.syncbase.SchemaManagerServer server;

  /**
   * Creates a new {@link SchemaManagerServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public SchemaManagerServerWrapper(io.v.v23.services.syncbase.SchemaManagerServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.SchemaMetadata.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "getSchemaMetadata",
              "// GetSchemaMetadata retrieves schema metadata for this database."
                  + "//"
                  + "// Requires: Client must have at least Read access on the Database."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.SchemaMetadata.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "setSchemaMetadata",
              "// SetSchemaMetadata stores schema metadata for this database."
                  + "//"
                  + "// Requires: Client must have at least Write access on the Database."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "SchemaManager",
        "io.v.v23.services.syncbase",
        "// SchemaManager implements the API for managing schema metadata attached"
            + "// to a Database."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("getSchemaMetadata".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format(
                "Couldn't get tags for method \"getSchemaMetadata\": %s", e.getMessage()));
      }
    }

    if ("setSchemaMetadata".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format(
                "Couldn't get tags for method \"setSchemaMetadata\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * GetSchemaMetadata retrieves schema metadata for this database.
   *<p>
   * Requires: Client must have at least Read access on the Database.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SchemaMetadata>
      getSchemaMetadata(io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.getSchemaMetadata(_ctx, _call);
  }

  /**
   * SetSchemaMetadata stores schema metadata for this database.
   *<p>
   * Requires: Client must have at least Write access on the Database.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSchemaMetadata(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.SchemaMetadata metadata) {

    return this.server.setSchemaMetadata(_ctx, _call, metadata);
  }
}
