// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: service.vdl
package io.v.v23.services.syncbase;

/**
 * Row represents a single row in a Collection.
 * All access checks are performed against the Collection ACL.
 */
@io.v.v23.vdl.VServer(serverWrapper = io.v.v23.services.syncbase.RowServerWrapper.class)
public interface RowServer {

  /**
   * Exists returns true only if this Row exists. Insufficient permissions
   * cause Exists to return false instead of an error.
   * Note, Exists on Row requires read permissions, unlike higher levels of
   * hierarchy which require resolve, because Row existence usually carries
   * more information.
   * TODO(ivanpi): Exists may fail with an error if higher levels of hierarchy
   * do not exist.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> exists(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.v23.services.syncbase.BatchHandle bh);

  /**
   * Get returns the value for this Row.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> get(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.v23.services.syncbase.BatchHandle bh);

  /**
   * Put writes the given value for this Row.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> put(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final io.v.v23.vdl.VdlAny value);

  /**
   * Delete deletes this Row.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.v23.services.syncbase.BatchHandle bh);
}
