// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

/**
 * RowOp represents a read or write operation on a row corresponding to the
 * given key.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.RowOp")
public class RowOp extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Key", index = 0)
  private java.lang.String key;

  @io.v.v23.vdl.GeneratedFromVdl(name = "LocalValue", index = 1)
  private io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> localValue;

  @io.v.v23.vdl.GeneratedFromVdl(name = "RemoteValue", index = 2)
  private io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> remoteValue;

  @io.v.v23.vdl.GeneratedFromVdl(name = "AncestorValue", index = 3)
  private io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> ancestorValue;

  /**
   * Vdl type for {@link RowOp}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(RowOp.class);

  /**
   * Creates a new zero-value instance of {@link RowOp}.
   */
  public RowOp() {
    super(VDL_TYPE);

    this.key = "";

    this.localValue =
        new io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value>(
            new com.google.common.reflect.TypeToken<
                io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value>>() {}.getType());

    this.remoteValue =
        new io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value>(
            new com.google.common.reflect.TypeToken<
                io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value>>() {}.getType());

    this.ancestorValue =
        new io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value>(
            new com.google.common.reflect.TypeToken<
                io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value>>() {}.getType());
  }

  /**
   * Creates a new instance of {@link RowOp} with the provided field values.
   */
  public RowOp(
      java.lang.String key,
      io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> localValue,
      io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> remoteValue,
      io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> ancestorValue) {
    super(VDL_TYPE);

    this.key = key;

    this.localValue = localValue;

    this.remoteValue = remoteValue;

    this.ancestorValue = ancestorValue;
  }

  /**
   * The key under conflict.
   */
  public java.lang.String getKey() {
    return this.key;
  }

  /**
   * The key under conflict.
   */
  public void setKey(java.lang.String key) {
    this.key = key;
  }

  /**
   * LocalValue contains the value read or written by local syncbase or nil.
   */
  public io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> getLocalValue() {
    return this.localValue;
  }

  /**
   * LocalValue contains the value read or written by local syncbase or nil.
   */
  public void setLocalValue(io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> localValue) {
    this.localValue = localValue;
  }

  /**
   * RemoteValue contains the value read or written by remote syncbase or nil.
   */
  public io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> getRemoteValue() {
    return this.remoteValue;
  }

  /**
   * RemoteValue contains the value read or written by remote syncbase or nil.
   */
  public void setRemoteValue(
      io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> remoteValue) {
    this.remoteValue = remoteValue;
  }

  /**
   * AncestorValue contains the value for the key which is the lowest common
   * ancestor of the two values represented by LocalValue and RemoteValue or
   * nil if no ancestor exists or if the operation was read.
   */
  public io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> getAncestorValue() {
    return this.ancestorValue;
  }

  /**
   * AncestorValue contains the value for the key which is the lowest common
   * ancestor of the two values represented by LocalValue and RemoteValue or
   * nil if no ancestor exists or if the operation was read.
   */
  public void setAncestorValue(
      io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> ancestorValue) {
    this.ancestorValue = ancestorValue;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    RowOp other = (RowOp) obj;

    if (this.key == null) {
      if (other.key != null) {
        return false;
      }
    } else if (!this.key.equals(other.key)) {
      return false;
    }

    if (this.localValue == null) {
      if (other.localValue != null) {
        return false;
      }
    } else if (!this.localValue.equals(other.localValue)) {
      return false;
    }

    if (this.remoteValue == null) {
      if (other.remoteValue != null) {
        return false;
      }
    } else if (!this.remoteValue.equals(other.remoteValue)) {
      return false;
    }

    if (this.ancestorValue == null) {
      if (other.ancestorValue != null) {
        return false;
      }
    } else if (!this.ancestorValue.equals(other.ancestorValue)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.key == null ? 0 : this.key.hashCode());

    result = prime * result + (this.localValue == null ? 0 : this.localValue.hashCode());

    result = prime * result + (this.remoteValue == null ? 0 : this.remoteValue.hashCode());

    result = prime * result + (this.ancestorValue == null ? 0 : this.ancestorValue.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "key:" + this.key;

    result += ", ";

    result += "localValue:" + this.localValue;

    result += ", ";

    result += "remoteValue:" + this.remoteValue;

    result += ", ";

    result += "ancestorValue:" + this.ancestorValue;

    return result + "}";
  }
}
