// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

/**
 * RowInfo contains a single operation performed on a row (in case of read or
 * write) or a range or rows (in case of scan) along with a mapping to each
 * of the batches that this operation belongs to.
 * For example, if Row1 was updated on local syncbase conflicting with a write
 * on remote syncbase as part of two separate batches, then it will be
 * represented by a single RowInfo with Write Operation containing the
 * respective local and remote values along with the batch id for both batches
 * stored in the BatchIds field.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.RowInfo")
public class RowInfo extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Op", index = 0)
  private io.v.v23.services.syncbase.Operation op;

  @io.v.v23.vdl.GeneratedFromVdl(name = "BatchIds", index = 1)
  private java.util.List<io.v.v23.vdl.VdlUint64> batchIds;

  /**
   * Vdl type for {@link RowInfo}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(RowInfo.class);

  /**
   * Creates a new zero-value instance of {@link RowInfo}.
   */
  public RowInfo() {
    super(VDL_TYPE);

    this.op = new io.v.v23.services.syncbase.Operation.Read();

    this.batchIds = new java.util.ArrayList<io.v.v23.vdl.VdlUint64>();
  }

  /**
   * Creates a new instance of {@link RowInfo} with the provided field values.
   */
  public RowInfo(
      io.v.v23.services.syncbase.Operation op, java.util.List<io.v.v23.vdl.VdlUint64> batchIds) {
    super(VDL_TYPE);

    this.op = op;

    this.batchIds = batchIds;
  }

  /**
   * Op is a specific operation represented by RowInfo
   */
  public io.v.v23.services.syncbase.Operation getOp() {
    return this.op;
  }

  /**
   * Op is a specific operation represented by RowInfo
   */
  public void setOp(io.v.v23.services.syncbase.Operation op) {
    this.op = op;
  }

  /**
   * BatchIds contains ids of all batches that this RowInfo is a part of.
   */
  public java.util.List<io.v.v23.vdl.VdlUint64> getBatchIds() {
    return this.batchIds;
  }

  /**
   * BatchIds contains ids of all batches that this RowInfo is a part of.
   */
  public void setBatchIds(java.util.List<io.v.v23.vdl.VdlUint64> batchIds) {
    this.batchIds = batchIds;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    RowInfo other = (RowInfo) obj;

    if (this.op == null) {
      if (other.op != null) {
        return false;
      }
    } else if (!this.op.equals(other.op)) {
      return false;
    }

    if (this.batchIds == null) {
      if (other.batchIds != null) {
        return false;
      }
    } else if (!this.batchIds.equals(other.batchIds)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.op == null ? 0 : this.op.hashCode());

    result = prime * result + (this.batchIds == null ? 0 : this.batchIds.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "op:" + this.op;

    result += ", ";

    result += "batchIds:" + this.batchIds;

    return result + "}";
  }
}
