// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

/**
 * ResolverType defines the possible conflict resolution policies.
 * A Conflict is defined as presence of two independent sets of updates
 * originating from the same version of an object. Syncbase
 * uses version vectors to determine sequence of changes to a given row. Hence
 * if device A updates a row with key "foo" from version V3 to V4, then syncs
 * with device B which further updates the same row from version V4 to V5 and
 * then V5 is synced back to device A, device A will see V5 as a forward
 * progression of "foo" and not a conflict with V3 of "foo". But in the
 * meantime if device A had already updated "foo" again from version V4 to
 * version V6 then there is a conflict between V5 and V6 with V4 being the
 * common ancestor.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.ResolverType")
public class ResolverType extends io.v.v23.vdl.VdlEnum {

  @io.v.v23.vdl.GeneratedFromVdl(name = "LastWins", index = 0)
  public static final ResolverType LastWins;

  @io.v.v23.vdl.GeneratedFromVdl(name = "AppResolves", index = 1)
  public static final ResolverType AppResolves;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Defer", index = 2)
  public static final ResolverType Defer;

  /**
   * Vdl type for {@link ResolverType}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(ResolverType.class);

  static {
    LastWins = new ResolverType("LastWins");

    AppResolves = new ResolverType("AppResolves");

    Defer = new ResolverType("Defer");
  }

  private ResolverType(String name) {
    super(VDL_TYPE, name);
  }

  /**
   * Returns the enum with the given name.
   */
  public static ResolverType valueOf(String name) {

    if ("LastWins".equals(name)) {
      return LastWins;
    }

    if ("AppResolves".equals(name)) {
      return AppResolves;
    }

    if ("Defer".equals(name)) {
      return Defer;
    }

    throw new java.lang.IllegalArgumentException();
  }
}
