// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

/**
 * ResolutionInfo contains the application’s reply to a conflict for a key,
 * providing the resolution value. The resolution may be over a group of keys
 * in which case the application must send a stream of ResolutionInfos with
 * the Continued field for the last ResolutionInfo representing the end of the
 * batch with a value false. ResolutionInfos sent as part of a batch will be
 * committed as a batch. If the commit fails, the Conflict will be re-sent.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.ResolutionInfo")
public class ResolutionInfo extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Key", index = 0)
  private java.lang.String key;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Selection", index = 1)
  private io.v.v23.services.syncbase.ValueSelection selection;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Result", index = 2)
  private io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> result;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Continued", index = 3)
  private boolean continued;

  /**
   * Vdl type for {@link ResolutionInfo}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(ResolutionInfo.class);

  /**
   * Creates a new zero-value instance of {@link ResolutionInfo}.
   */
  public ResolutionInfo() {
    super(VDL_TYPE);

    this.key = "";

    this.selection = io.v.v23.services.syncbase.ValueSelection.Local;

    this.result =
        new io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value>(
            new com.google.common.reflect.TypeToken<
                io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value>>() {}.getType());

    this.continued = false;
  }

  /**
   * Creates a new instance of {@link ResolutionInfo} with the provided field values.
   */
  public ResolutionInfo(
      java.lang.String key,
      io.v.v23.services.syncbase.ValueSelection selection,
      io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> result,
      boolean continued) {
    super(VDL_TYPE);

    this.key = key;

    this.selection = selection;

    this.result = result;

    this.continued = continued;
  }

  /**
   * Key is the key under conflict.
   */
  public java.lang.String getKey() {
    return this.key;
  }

  /**
   * Key is the key under conflict.
   */
  public void setKey(java.lang.String key) {
    this.key = key;
  }

  /**
   * Selection represents the value that was selected as resolution.
   */
  public io.v.v23.services.syncbase.ValueSelection getSelection() {
    return this.selection;
  }

  /**
   * Selection represents the value that was selected as resolution.
   */
  public void setSelection(io.v.v23.services.syncbase.ValueSelection selection) {
    this.selection = selection;
  }

  /**
   * Result is the resolved value for the key. This field should be used only
   * if value of Selection field is 'Other'. If the result of a resolution is
   * delete for this key then add Value with nil Bytes.
   */
  public io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> getResult() {
    return this.result;
  }

  /**
   * Result is the resolved value for the key. This field should be used only
   * if value of Selection field is 'Other'. If the result of a resolution is
   * delete for this key then add Value with nil Bytes.
   */
  public void setResult(io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.Value> result) {
    this.result = result;
  }

  /**
   * Continued represents whether the batch of ResolutionInfos has ended.
   */
  public boolean getContinued() {
    return this.continued;
  }

  /**
   * Continued represents whether the batch of ResolutionInfos has ended.
   */
  public void setContinued(boolean continued) {
    this.continued = continued;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    ResolutionInfo other = (ResolutionInfo) obj;

    if (this.key == null) {
      if (other.key != null) {
        return false;
      }
    } else if (!this.key.equals(other.key)) {
      return false;
    }

    if (this.selection == null) {
      if (other.selection != null) {
        return false;
      }
    } else if (!this.selection.equals(other.selection)) {
      return false;
    }

    if (this.result == null) {
      if (other.result != null) {
        return false;
      }
    } else if (!this.result.equals(other.result)) {
      return false;
    }

    if (this.continued != other.continued) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.key == null ? 0 : this.key.hashCode());

    result = prime * result + (this.selection == null ? 0 : this.selection.hashCode());

    result = prime * result + (this.result == null ? 0 : this.result.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.continued).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "key:" + this.key;

    result += ", ";

    result += "selection:" + this.selection;

    result += ", ";

    result += "result:" + this.result;

    result += ", ";

    result += "continued:" + this.continued;

    return result + "}";
  }
}
