// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

/**
 * Operation represents a specific operation on a row or a set of rows that is
 * a part of the conflict.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.Operation")
public class Operation extends io.v.v23.vdl.VdlUnion {
  private static final long serialVersionUID = 1L;

  /**
   * Read represents a read operation performed on a specific row. For a given
   * row key there can only be at max one Read operation within a conflict.
   */
  @io.v.v23.vdl.GeneratedFromVdl(name = "Read", index = 0)
  public static class Read extends Operation {
    private static final long serialVersionUID = 1L;
    private io.v.v23.services.syncbase.RowOp elem;

    public Read(io.v.v23.services.syncbase.RowOp elem) {
      super(0, elem);
      this.elem = elem;
    }

    public Read() {
      this(new io.v.v23.services.syncbase.RowOp());
    }

    @Override
    public io.v.v23.services.syncbase.RowOp getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (elem == null ? 0 : elem.hashCode());
    }
  }

  /**
   * Write represents a write operation performed on a specific row. For a
   * given row key there can only be at max one Write operation within a
   * conflict.
   */
  @io.v.v23.vdl.GeneratedFromVdl(name = "Write", index = 1)
  public static class Write extends Operation {
    private static final long serialVersionUID = 1L;
    private io.v.v23.services.syncbase.RowOp elem;

    public Write(io.v.v23.services.syncbase.RowOp elem) {
      super(1, elem);
      this.elem = elem;
    }

    public Write() {
      this(new io.v.v23.services.syncbase.RowOp());
    }

    @Override
    public io.v.v23.services.syncbase.RowOp getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (elem == null ? 0 : elem.hashCode());
    }
  }

  /**
   * Scan represents a scan operation performed over a specific range of keys.
   * For a given key range there can be at max one ScanOp within the Conflict.
   */
  @io.v.v23.vdl.GeneratedFromVdl(name = "Scan", index = 2)
  public static class Scan extends Operation {
    private static final long serialVersionUID = 1L;
    private io.v.v23.services.syncbase.ScanOp elem;

    public Scan(io.v.v23.services.syncbase.ScanOp elem) {
      super(2, elem);
      this.elem = elem;
    }

    public Scan() {
      this(new io.v.v23.services.syncbase.ScanOp());
    }

    @Override
    public io.v.v23.services.syncbase.ScanOp getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return (elem == null ? 0 : elem.hashCode());
    }
  }

  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Operation.class);

  public Operation(int index, Object value) {
    super(VDL_TYPE, index, value);
  }
}
