// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

/**
 * DevModeUpdateVClockOpts specifies what DevModeUpdateVClock should do, as
 * described below.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.DevModeUpdateVClockOpts")
public class DevModeUpdateVClockOpts extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "NtpHost", index = 0)
  private java.lang.String ntpHost;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Now", index = 1)
  private org.joda.time.DateTime now;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ElapsedTime", index = 2)
  private org.joda.time.Duration elapsedTime;

  @io.v.v23.vdl.GeneratedFromVdl(name = "DoNtpUpdate", index = 3)
  private boolean doNtpUpdate;

  @io.v.v23.vdl.GeneratedFromVdl(name = "DoLocalUpdate", index = 4)
  private boolean doLocalUpdate;

  /**
   * Vdl type for {@link DevModeUpdateVClockOpts}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(DevModeUpdateVClockOpts.class);

  /**
   * Creates a new zero-value instance of {@link DevModeUpdateVClockOpts}.
   */
  public DevModeUpdateVClockOpts() {
    super(VDL_TYPE);

    this.ntpHost = "";

    this.now = null;

    this.elapsedTime = null;

    this.doNtpUpdate = false;

    this.doLocalUpdate = false;
  }

  /**
   * Creates a new instance of {@link DevModeUpdateVClockOpts} with the provided field values.
   */
  public DevModeUpdateVClockOpts(
      java.lang.String ntpHost,
      org.joda.time.DateTime now,
      org.joda.time.Duration elapsedTime,
      boolean doNtpUpdate,
      boolean doLocalUpdate) {
    super(VDL_TYPE);

    this.ntpHost = ntpHost;

    this.now = now;

    this.elapsedTime = elapsedTime;

    this.doNtpUpdate = doNtpUpdate;

    this.doLocalUpdate = doLocalUpdate;
  }

  /**
   * If specified, sets the NTP host to talk to for subsequent NTP requests.
   */
  public java.lang.String getNtpHost() {
    return this.ntpHost;
  }

  /**
   * If specified, sets the NTP host to talk to for subsequent NTP requests.
   */
  public void setNtpHost(java.lang.String ntpHost) {
    this.ntpHost = ntpHost;
  }

  /**
   * If Now is specified, the fake system clock is updated to the given values
   * of Now and ElapsedTime. If Now is not specified (i.e. takes the zero
   * value), the system clock is not touched by DevModeUpdateVClock.
   */
  public org.joda.time.DateTime getNow() {
    return this.now;
  }

  /**
   * If Now is specified, the fake system clock is updated to the given values
   * of Now and ElapsedTime. If Now is not specified (i.e. takes the zero
   * value), the system clock is not touched by DevModeUpdateVClock.
   */
  public void setNow(org.joda.time.DateTime now) {
    this.now = now;
  }

  public org.joda.time.Duration getElapsedTime() {
    return this.elapsedTime;
  }

  public void setElapsedTime(org.joda.time.Duration elapsedTime) {
    this.elapsedTime = elapsedTime;
  }

  /**
   * If specified, the clock daemon's local and/or NTP update code is triggered
   * after applying the updates specified by the fields above. (Helpful because
   * otherwise these only run periodically.) These functions work even if the
   * clock daemon hasn't been started.
   */
  public boolean getDoNtpUpdate() {
    return this.doNtpUpdate;
  }

  /**
   * If specified, the clock daemon's local and/or NTP update code is triggered
   * after applying the updates specified by the fields above. (Helpful because
   * otherwise these only run periodically.) These functions work even if the
   * clock daemon hasn't been started.
   */
  public void setDoNtpUpdate(boolean doNtpUpdate) {
    this.doNtpUpdate = doNtpUpdate;
  }

  public boolean getDoLocalUpdate() {
    return this.doLocalUpdate;
  }

  public void setDoLocalUpdate(boolean doLocalUpdate) {
    this.doLocalUpdate = doLocalUpdate;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    DevModeUpdateVClockOpts other = (DevModeUpdateVClockOpts) obj;

    if (this.ntpHost == null) {
      if (other.ntpHost != null) {
        return false;
      }
    } else if (!this.ntpHost.equals(other.ntpHost)) {
      return false;
    }

    if (this.now == null) {
      if (other.now != null) {
        return false;
      }
    } else if (!this.now.equals(other.now)) {
      return false;
    }

    if (this.elapsedTime == null) {
      if (other.elapsedTime != null) {
        return false;
      }
    } else if (!this.elapsedTime.equals(other.elapsedTime)) {
      return false;
    }

    if (this.doNtpUpdate != other.doNtpUpdate) {
      return false;
    }

    if (this.doLocalUpdate != other.doLocalUpdate) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.ntpHost == null ? 0 : this.ntpHost.hashCode());

    result = prime * result + (this.now == null ? 0 : this.now.hashCode());

    result = prime * result + (this.elapsedTime == null ? 0 : this.elapsedTime.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.doNtpUpdate).hashCode();

    result = prime * result + java.lang.Boolean.valueOf(this.doLocalUpdate).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "ntpHost:" + this.ntpHost;

    result += ", ";

    result += "now:" + this.now;

    result += ", ";

    result += "elapsedTime:" + this.elapsedTime;

    result += ", ";

    result += "doNtpUpdate:" + this.doNtpUpdate;

    result += ", ";

    result += "doLocalUpdate:" + this.doLocalUpdate;

    return result + "}";
  }
}
