// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.v23.services.syncbase;

/**
 * Wrapper for {@link DatabaseWatcherServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class DatabaseWatcherServerWrapper {
  private final io.v.v23.services.syncbase.DatabaseWatcherServer server;

  private final io.v.v23.services.watch.GlobWatcherServerWrapper wrapperGlobWatcher;

  /**
   * Creates a new {@link DatabaseWatcherServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public DatabaseWatcherServerWrapper(io.v.v23.services.syncbase.DatabaseWatcherServer server) {
    this.server = server;

    this.wrapperGlobWatcher = new io.v.v23.services.watch.GlobWatcherServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BatchHandle.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.v23.services.watch.ResumeMarker>() {}.getType())));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "getResumeMarker",
              "// GetResumeMarker returns the ResumeMarker that points to the current end"
                  + "// of the event log. GetResumeMarker() can be called on a batch."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.v23.services.watch.ResumeMarker>() {}.getType())));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<
                          io.v.v23.services.syncbase.CollectionRowPattern>>() {}.getType())));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "watchPatterns",
              "// WatchPatterns returns a stream of changes that match any of the specified"
                  + "// patterns. At least one pattern must be specified."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "DatabaseWatcher",
        "io.v.v23.services.syncbase",
        "// DatabaseWatcher allows a client to watch for updates to the database. For"
            + "// each watch request, the client will receive a reliable stream of watch events"
            + "// without re-ordering. Only rows and collections matching at least one of the"
            + "// patterns are returned. Rows in collections with no Read access are also"
            + "// filtered out."
            + "//"
            + "// Watching is done by starting a streaming RPC. The RPC takes a ResumeMarker"
            + "// argument that points to a particular place in the database event log. If an"
            + "// empty ResumeMarker is provided, the WatchStream will begin with a Change"
            + "// batch containing the initial state, always starting with an empty update for"
            + "// the root entity. Otherwise, the WatchStream will contain only changes since"
            + "// the provided ResumeMarker."
            + "// See watch.GlobWatcher for a detailed explanation of the behavior."
            + "//"
            + "// The result stream consists of a never-ending sequence of Change messages"
            + "// (until the call fails or is canceled). Each Change contains the Name field"
            + "// with the Vanadium name of the watched entity relative to the database:"
            + "// - \"<encCxId>/<rowKey>\" for row updates"
            + "// - \"<encCxId>\" for collection updates"
            + "// - \"\" for the initial root entity update"
            + "// The Value field is a StoreChange."
            + "// If the client has no access to a row specified in a change, that change is"
            + "// excluded from the result stream."
            + "//"
            + "// Note: A single Watch Change batch may contain changes from more than one"
            + "// batch as originally committed on a remote Syncbase or obtained from conflict"
            + "// resolution. However, changes from a single original batch will always appear"
            + "// in the same Change batch."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("getResumeMarker".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"getResumeMarker\": %s", e.getMessage()));
      }
    }

    if ("watchPatterns".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"watchPatterns\": %s", e.getMessage()));
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperGlobWatcher.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  /**
   * GetResumeMarker returns the ResumeMarker that points to the current end
   * of the event log. GetResumeMarker() can be called on a batch.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.watch.ResumeMarker>
      getResumeMarker(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.v23.services.syncbase.BatchHandle bh) {

    return this.server.getResumeMarker(_ctx, _call, bh);
  }

  /**
   * WatchPatterns returns a stream of changes that match any of the specified
   * patterns. At least one pattern must be specified.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> watchPatterns(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.watch.ResumeMarker resumeMarker,
      final java.util.List<io.v.v23.services.syncbase.CollectionRowPattern> patterns) {

    io.v.v23.vdl.ServerStream<io.v.v23.services.watch.Change, java.lang.Void> _stream =
        new io.v.v23.vdl.ServerStream<io.v.v23.services.watch.Change, java.lang.Void>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(
              io.v.v23.services.watch.Change _item) {
            java.lang.reflect.Type _type = io.v.v23.services.watch.Change.class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> recv() {
            java.lang.reflect.Type _type = java.lang.Void.class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, java.lang.Void>() {
                  @Override
                  public java.lang.Void apply(Object result) {
                    return (java.lang.Void) result;
                  }
                });
          }
        };

    return this.server.watchPatterns(_ctx, _call, resumeMarker, patterns, _stream);
  }

  /**
   * WatchGlob returns a stream of changes that match a pattern.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> watchGlob(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.watch.GlobRequest req)
      throws io.v.v23.verror.VException {

    return this.wrapperGlobWatcher.watchGlob(ctx, call, req);
  }
}
