// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.v23.services.syncbase;

/**
 * Implementation of the {@link DatabaseWatcherClient} interface.
 */
final class DatabaseWatcherClientImpl implements io.v.v23.services.syncbase.DatabaseWatcherClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  private final io.v.v23.services.watch.GlobWatcherClient implGlobWatcher;

  /**
   * Creates a new instance of {@link DatabaseWatcherClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public DatabaseWatcherClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implGlobWatcher =
          io.v.v23.services.watch.GlobWatcherClientFactory.getGlobWatcherClient(vName, opts);
    }
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface DatabaseWatcherClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.watch.ResumeMarker>
      getResumeMarker(
          io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BatchHandle bh) {
    return getResumeMarker(_context, bh, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.watch.ResumeMarker>
      getResumeMarker(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BatchHandle bh,
          io.v.v23.Options _opts) {
    return getResumeMarker(_context, bh, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.watch.ResumeMarker>
      getResumeMarker(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BatchHandle bh,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {bh};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.syncbase.BatchHandle.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "getResumeMarker", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.services.watch.ResumeMarker>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.v23.services.watch.ResumeMarker>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.services.watch.ResumeMarker>() {}.getType(),
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.v23.services.watch.ResumeMarker>() {
                      @Override
                      public io.v.v23.services.watch.ResumeMarker apply(Object[] _results) {

                        return (io.v.v23.services.watch.ResumeMarker) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void>
      watchPatterns(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.watch.ResumeMarker resumeMarker,
          final java.util.List<io.v.v23.services.syncbase.CollectionRowPattern> patterns) {
    return watchPatterns(_context, resumeMarker, patterns, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void>
      watchPatterns(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.watch.ResumeMarker resumeMarker,
          final java.util.List<io.v.v23.services.syncbase.CollectionRowPattern> patterns,
          io.v.v23.Options _opts) {
    return watchPatterns(
        _context, resumeMarker, patterns, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void>
      watchPatterns(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.watch.ResumeMarker resumeMarker,
          final java.util.List<io.v.v23.services.syncbase.CollectionRowPattern> patterns,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {resumeMarker, patterns};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          new com.google.common.reflect.TypeToken<
              io.v.v23.services.watch.ResumeMarker>() {}.getType(),
          new com.google.common.reflect.TypeToken<
              java.util.List<io.v.v23.services.syncbase.CollectionRowPattern>>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "watchPatterns", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<
        java.lang.Void, io.v.v23.services.watch.Change, java.lang.Void>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(
          final java.lang.Void item) {
        final java.lang.reflect.Type type = java.lang.Void.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.watch.Change>
          recv() {
        final java.lang.reflect.Type recvType = io.v.v23.services.watch.Change.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, io.v.v23.services.watch.Change>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<
                          io.v.v23.services.watch.Change>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<
                            Object, io.v.v23.services.watch.Change>() {
                          @Override
                          public io.v.v23.services.watch.Change apply(Object result) {
                            return (io.v.v23.services.watch.Change) result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> finish() {

        final java.lang.reflect.Type[] resultTypes = new java.lang.reflect.Type[] {};

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<Object[], java.lang.Void>() {
                          @Override
                          public java.lang.Void apply(Object[] _results) {

                            return null;
                          }
                        });
                  }
                }));
      }
    };
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void> watchGlob(
      io.v.v23.context.VContext _context, final io.v.v23.services.watch.GlobRequest req) {

    return this.implGlobWatcher.watchGlob(_context, req);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void> watchGlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.watch.GlobRequest req,
      io.v.v23.Options _opts) {

    return this.implGlobWatcher.watchGlob(_context, req, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void> watchGlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.watch.GlobRequest req,
      io.v.v23.options.RpcOptions _opts) {

    return this.implGlobWatcher.watchGlob(_context, req, _opts);
  }
}
