// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: service.vdl
package io.v.v23.services.syncbase;

/**
 * DatabaseWatcher allows a client to watch for updates to the database. For
 * each watch request, the client will receive a reliable stream of watch events
 * without re-ordering. Only rows and collections matching at least one of the
 * patterns are returned. Rows in collections with no Read access are also
 * filtered out.
 *<p>
 * Watching is done by starting a streaming RPC. The RPC takes a ResumeMarker
 * argument that points to a particular place in the database event log. If an
 * empty ResumeMarker is provided, the WatchStream will begin with a Change
 * batch containing the initial state, always starting with an empty update for
 * the root entity. Otherwise, the WatchStream will contain only changes since
 * the provided ResumeMarker.
 * See watch.GlobWatcher for a detailed explanation of the behavior.
 *<p>
 * The result stream consists of a never-ending sequence of Change messages
 * (until the call fails or is canceled). Each Change contains the Name field
 * with the Vanadium name of the watched entity relative to the database:
 * - "<encCxId>/<rowKey>" for row updates
 * - "<encCxId>" for collection updates
 * - "" for the initial root entity update
 * The Value field is a StoreChange.
 * If the client has no access to a row specified in a change, that change is
 * excluded from the result stream.
 *<p>
 * Note: A single Watch Change batch may contain changes from more than one
 * batch as originally committed on a remote Syncbase or obtained from conflict
 * resolution. However, changes from a single original batch will always appear
 * in the same Change batch.
 */
public interface DatabaseWatcherClient extends io.v.v23.services.watch.GlobWatcherClient {

  /**
   * GetResumeMarker returns the ResumeMarker that points to the current end
   * of the event log. GetResumeMarker() can be called on a batch.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.watch.ResumeMarker>
      getResumeMarker(
          io.v.v23.context.VContext context, final io.v.v23.services.syncbase.BatchHandle bh);

  /**
   * GetResumeMarker returns the ResumeMarker that points to the current end
   * of the event log. GetResumeMarker() can be called on a batch.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.watch.ResumeMarker>
      getResumeMarker(
          io.v.v23.context.VContext context,
          final io.v.v23.services.syncbase.BatchHandle bh,
          io.v.v23.Options opts);

  /**
   * GetResumeMarker returns the ResumeMarker that points to the current end
   * of the event log. GetResumeMarker() can be called on a batch.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.watch.ResumeMarker>
      getResumeMarker(
          io.v.v23.context.VContext context,
          final io.v.v23.services.syncbase.BatchHandle bh,
          io.v.v23.options.RpcOptions opts);

  /**
   * WatchPatterns returns a stream of changes that match any of the specified
   * patterns. At least one pattern must be specified.
   */
  io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void> watchPatterns(
      io.v.v23.context.VContext context,
      final io.v.v23.services.watch.ResumeMarker resumeMarker,
      final java.util.List<io.v.v23.services.syncbase.CollectionRowPattern> patterns);

  /**
   * WatchPatterns returns a stream of changes that match any of the specified
   * patterns. At least one pattern must be specified.
   */
  @java.lang.Deprecated
  io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void> watchPatterns(
      io.v.v23.context.VContext context,
      final io.v.v23.services.watch.ResumeMarker resumeMarker,
      final java.util.List<io.v.v23.services.syncbase.CollectionRowPattern> patterns,
      io.v.v23.Options opts);

  /**
   * WatchPatterns returns a stream of changes that match any of the specified
   * patterns. At least one pattern must be specified.
   */
  io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void> watchPatterns(
      io.v.v23.context.VContext context,
      final io.v.v23.services.watch.ResumeMarker resumeMarker,
      final java.util.List<io.v.v23.services.syncbase.CollectionRowPattern> patterns,
      io.v.v23.options.RpcOptions opts);
}
