// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.v23.services.syncbase;

/**
 * Wrapper for {@link DatabaseServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class DatabaseServerWrapper {
  private final io.v.v23.services.syncbase.DatabaseServer server;

  private final io.v.v23.services.permissions.ObjectServerWrapper wrapperObject;

  private final io.v.v23.services.watch.GlobWatcherServerWrapper wrapperGlobWatcher;

  private final io.v.v23.services.syncbase.DatabaseWatcherServerWrapper wrapperDatabaseWatcher;

  private final io.v.v23.services.syncbase.SyncgroupManagerServerWrapper wrapperSyncgroupManager;

  private final io.v.v23.services.syncbase.BlobManagerServerWrapper wrapperBlobManager;

  private final io.v.v23.services.syncbase.SchemaManagerServerWrapper wrapperSchemaManager;

  private final io.v.v23.services.syncbase.ConflictManagerServerWrapper wrapperConflictManager;

  /**
   * Creates a new {@link DatabaseServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public DatabaseServerWrapper(io.v.v23.services.syncbase.DatabaseServer server) {
    this.server = server;

    this.wrapperObject = new io.v.v23.services.permissions.ObjectServerWrapper(server);

    this.wrapperGlobWatcher = new io.v.v23.services.watch.GlobWatcherServerWrapper(server);

    this.wrapperDatabaseWatcher =
        new io.v.v23.services.syncbase.DatabaseWatcherServerWrapper(server);

    this.wrapperSyncgroupManager =
        new io.v.v23.services.syncbase.SyncgroupManagerServerWrapper(server);

    this.wrapperBlobManager = new io.v.v23.services.syncbase.BlobManagerServerWrapper(server);

    this.wrapperSchemaManager = new io.v.v23.services.syncbase.SchemaManagerServerWrapper(server);

    this.wrapperConflictManager =
        new io.v.v23.services.syncbase.ConflictManagerServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.v23.vdl.VdlOptional<
                          io.v.v23.services.syncbase.SchemaMetadata>>() {}.getType())));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.v23.security.access.Permissions>() {}.getType())));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "create",
              "// Create creates this Database. Permissions must be non-nil and include at"
                  + "// least one admin."
                  + "// Create requires the caller to have Write permission at the Service."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "destroy",
              "// Destroy destroys this Database, permanently removing all of its data."
                  + "// TODO(sadovsky): Specify what happens to syncgroups."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Boolean.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Resolve"),
                  io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "exists",
              "// Exists returns true only if this Database exists. Insufficient permissions"
                  + "// cause Exists to return false instead of an error."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BatchHandle.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<io.v.v23.services.syncbase.Id>>() {}.getType())));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "listCollections",
              "// ListCollections returns an unsorted list of all Collection ids that the"
                  + "// caller is allowed to see."
                  + "// This method exists on Database but not on Service because for the latter"
                  + "// we can simply use glob, while for the former glob lists only Collections"
                  + "// visible in a new snapshot of the Database, ignoring user batches."
                  + "// (Note that the same issue is present in glob on Collection, where Scan can"
                  + "// be used instead if batch awareness is required.)"
                  + "// Note, the glob client library checks Resolve access on every component"
                  + "// along the path (by doing a Dispatcher.Lookup), whereas this doesn't happen"
                  + "// for other RPCs."
                  + "// TODO(ivanpi): Resolve should be checked on all RPCs."
                  + "// TODO(sadovsky): Maybe switch to streaming RPC."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BatchHandle.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<io.v.v23.vdl.VdlAny>>() {}.getType())));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "exec",
              "// Exec executes a syncQL query with positional parameters and returns all"
                  + "// results as specified by the query's select/delete statement."
                  + "// Concurrency semantics are documented in model.go."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BatchOptions.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BatchHandle.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "beginBatch",
              "// BeginBatch creates a new batch. It returns a batch handle to pass in when"
                  + "// calling batch-aware RPCs."
                  + "// Concurrency semantics are documented in model.go."
                  + "// All batch-aware RPCs can also be called outside a batch (with an empty"
                  + "// handle), with the exception of Commit and Abort which only make sense on"
                  + "// a batch. Note that glob RPCs are not batch-aware."
                  + "// TODO(sadovsky): Maybe make BatchOptions optional. Also, rename 'bo' to"
                  + "// 'opts' once v.io/i/912 is resolved for Java."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BatchHandle.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "commit",
              "// Commit persists the pending changes to the database."
                  + "// If the batch is readonly, Commit() will fail with ErrReadOnlyBatch; Abort()"
                  + "// should be used instead."
                  + "// If the BatchHandle is empty, Commit() will fail with ErrNotBoundToBatch."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BatchHandle.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "abort",
              "// Abort notifies the server that any pending changes can be discarded."
                  + "// It is not strictly required, but it may allow the server to release locks"
                  + "// or other resources sooner than if it was not called."
                  + "// If the BatchHandle is empty, Abort() will fail with ErrNotBoundToBatch."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "pauseSync",
              "// PauseSync pauses sync for this database. Incoming sync, as well as outgoing"
                  + "// sync of subsequent writes, will be disabled until ResumeSync is called."
                  + "// PauseSync is idempotent."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "resumeSync",
              "// ResumeSync resumes sync for this database. ResumeSync is idempotent." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Database",
        "io.v.v23.services.syncbase",
        "// Database represents a set of Collections. Batches, queries, syncgroups, and"
            + "// watch all operate at the Database level."
            + "// Database.Glob operates over Collection ids."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("abort".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"abort\": %s", e.getMessage()));
      }
    }

    if ("beginBatch".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"beginBatch\": %s", e.getMessage()));
      }
    }

    if ("commit".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"commit\": %s", e.getMessage()));
      }
    }

    if ("create".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"create\": %s", e.getMessage()));
      }
    }

    if ("destroy".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"destroy\": %s", e.getMessage()));
      }
    }

    if ("exec".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"exec\": %s", e.getMessage()));
      }
    }

    if ("exists".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Resolve"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"exists\": %s", e.getMessage()));
      }
    }

    if ("listCollections".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"listCollections\": %s", e.getMessage()));
      }
    }

    if ("pauseSync".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"pauseSync\": %s", e.getMessage()));
      }
    }

    if ("resumeSync".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"resumeSync\": %s", e.getMessage()));
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperObject.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperGlobWatcher.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperDatabaseWatcher.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperSyncgroupManager.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperBlobManager.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperSchemaManager.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperConflictManager.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  /**
   * Create creates this Database. Permissions must be non-nil and include at
   * least one admin.
   * Create requires the caller to have Write permission at the Service.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.SchemaMetadata> metadata,
      final io.v.v23.security.access.Permissions perms) {

    return this.server.create(_ctx, _call, metadata, perms);
  }

  /**
   * Destroy destroys this Database, permanently removing all of its data.
   * TODO(sadovsky): Specify what happens to syncgroups.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroy(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.destroy(_ctx, _call);
  }

  /**
   * Exists returns true only if this Database exists. Insufficient permissions
   * cause Exists to return false instead of an error.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> exists(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.exists(_ctx, _call);
  }

  /**
   * ListCollections returns an unsorted list of all Collection ids that the
   * caller is allowed to see.
   * This method exists on Database but not on Service because for the latter
   * we can simply use glob, while for the former glob lists only Collections
   * visible in a new snapshot of the Database, ignoring user batches.
   * (Note that the same issue is present in glob on Collection, where Scan can
   * be used instead if batch awareness is required.)
   * Note, the glob client library checks Resolve access on every component
   * along the path (by doing a Dispatcher.Lookup), whereas this doesn't happen
   * for other RPCs.
   * TODO(ivanpi): Resolve should be checked on all RPCs.
   * TODO(sadovsky): Maybe switch to streaming RPC.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.syncbase.Id>>
      listCollections(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.v23.services.syncbase.BatchHandle bh) {

    return this.server.listCollections(_ctx, _call, bh);
  }

  /**
   * Exec executes a syncQL query with positional parameters and returns all
   * results as specified by the query's select/delete statement.
   * Concurrency semantics are documented in model.go.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> exec(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final java.lang.String query,
      final java.util.List<io.v.v23.vdl.VdlAny> params) {

    io.v.v23.vdl.ServerStream<java.util.List<io.v.v23.vdl.VdlAny>, java.lang.Void> _stream =
        new io.v.v23.vdl.ServerStream<java.util.List<io.v.v23.vdl.VdlAny>, java.lang.Void>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(
              java.util.List<io.v.v23.vdl.VdlAny> _item) {
            java.lang.reflect.Type _type =
                new com.google.common.reflect.TypeToken<
                    java.util.List<io.v.v23.vdl.VdlAny>>() {}.getType();
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> recv() {
            java.lang.reflect.Type _type = java.lang.Void.class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, java.lang.Void>() {
                  @Override
                  public java.lang.Void apply(Object result) {
                    return (java.lang.Void) result;
                  }
                });
          }
        };

    return this.server.exec(_ctx, _call, bh, query, params, _stream);
  }

  /**
   * BeginBatch creates a new batch. It returns a batch handle to pass in when
   * calling batch-aware RPCs.
   * Concurrency semantics are documented in model.go.
   * All batch-aware RPCs can also be called outside a batch (with an empty
   * handle), with the exception of Commit and Abort which only make sense on
   * a batch. Note that glob RPCs are not batch-aware.
   * TODO(sadovsky): Maybe make BatchOptions optional. Also, rename 'bo' to
   * 'opts' once v.io/i/912 is resolved for Java.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.BatchHandle>
      beginBatch(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.v23.services.syncbase.BatchOptions bo) {

    return this.server.beginBatch(_ctx, _call, bo);
  }

  /**
   * Commit persists the pending changes to the database.
   * If the batch is readonly, Commit() will fail with ErrReadOnlyBatch; Abort()
   * should be used instead.
   * If the BatchHandle is empty, Commit() will fail with ErrNotBoundToBatch.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> commit(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.BatchHandle bh) {

    return this.server.commit(_ctx, _call, bh);
  }

  /**
   * Abort notifies the server that any pending changes can be discarded.
   * It is not strictly required, but it may allow the server to release locks
   * or other resources sooner than if it was not called.
   * If the BatchHandle is empty, Abort() will fail with ErrNotBoundToBatch.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> abort(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.BatchHandle bh) {

    return this.server.abort(_ctx, _call, bh);
  }

  /**
   * PauseSync pauses sync for this database. Incoming sync, as well as outgoing
   * sync of subsequent writes, will be disabled until ResumeSync is called.
   * PauseSync is idempotent.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> pauseSync(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.pauseSync(_ctx, _call);
  }

  /**
   * ResumeSync resumes sync for this database. ResumeSync is idempotent.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> resumeSync(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.resumeSync(_ctx, _call);
  }

  /**
   * GetPermissions returns the complete, current Permissions for an object. The
   * returned version can be passed to a subsequent call to SetPermissions for
   * optimistic concurrency control. A successful call to SetPermissions will
   * invalidate version, and the client must call GetPermissions again to get
   * the current version.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectServer.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
          throws io.v.v23.verror.VException {

    return this.wrapperObject.getPermissions(ctx, call);
  }

  /**
   * SetPermissions replaces the current Permissions for an object.  version
   * allows for optional, optimistic concurrency control.  If non-empty,
   * version's value must come from GetPermissions.  If any client has
   * successfully called SetPermissions in the meantime, the version will be
   * stale and SetPermissions will fail.  If empty, SetPermissions performs an
   * unconditional update.
   *<p>
   * Permissions objects are expected to be small.  It is up to the
   * implementation to define the exact limit, though it should probably be
   * around 100KB.  Large lists of principals can be represented concisely using
   * blessings.
   *<p>
   * There is some ambiguity when calling SetPermissions on a mount point.
   * Does it affect the mount itself or does it affect the service endpoint
   * that the mount points to?  The chosen behavior is that it affects the
   * service endpoint.  To modify the mount point's Permissions, use
   * ResolveToMountTable to get an endpoint and call SetPermissions on that.
   * This means that clients must know when a name refers to a mount point to
   * change its Permissions.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version)
      throws io.v.v23.verror.VException {

    return this.wrapperObject.setPermissions(ctx, call, perms, version);
  }

  /**
   * CommitBlob marks the blob as immutable.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> commitBlob(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.syncbase.BlobRef br)
      throws io.v.v23.verror.VException {

    return this.wrapperBlobManager.commitBlob(ctx, call, br);
  }

  /**
   * CreateBlob returns a BlobRef for a newly created blob.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.BlobRef>
      createBlob(io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
          throws io.v.v23.verror.VException {

    return this.wrapperBlobManager.createBlob(ctx, call);
  }

  /**
   * DeleteBlob locally deletes the blob (committed or uncommitted).
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> deleteBlob(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.syncbase.BlobRef br)
      throws io.v.v23.verror.VException {

    return this.wrapperBlobManager.deleteBlob(ctx, call, br);
  }

  /**
   * FetchBlob initiates fetching a blob if not locally found. priority
   * controls the network priority of the blob. Higher priority blobs are
   * fetched before the lower priority ones. However, an ongoing blob
   * transfer is not interrupted. Status updates are streamed back to the
   * client as fetch is in progress.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> fetchBlob(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.syncbase.BlobRef br,
      final io.v.v23.vdl.VdlUint64 priority)
      throws io.v.v23.verror.VException {

    return this.wrapperBlobManager.fetchBlob(ctx, call, br, priority);
  }

  /**
   * GetBlobSize returns the count of bytes written as part of the blob
   * (committed or uncommitted).
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> getBlobSize(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.syncbase.BlobRef br)
      throws io.v.v23.verror.VException {

    return this.wrapperBlobManager.getBlobSize(ctx, call, br);
  }

  /**
   * GetBlob returns the byte stream from a committed blob starting at offset.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> getBlob(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.syncbase.BlobRef br,
      final long offset)
      throws io.v.v23.verror.VException {

    return this.wrapperBlobManager.getBlob(ctx, call, br, offset);
  }

  /**
   * KeepBlob locally caches the blob with the specified rank. Lower
   * ranked blobs are more eagerly evicted.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> keepBlob(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.syncbase.BlobRef br,
      final io.v.v23.vdl.VdlUint64 rank)
      throws io.v.v23.verror.VException {

    return this.wrapperBlobManager.keepBlob(ctx, call, br, rank);
  }

  /**
   * PinBlob locally pins the blob so that it is not evicted.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> pinBlob(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.syncbase.BlobRef br)
      throws io.v.v23.verror.VException {

    return this.wrapperBlobManager.pinBlob(ctx, call, br);
  }

  /**
   * PutBlob appends the byte stream to the blob.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> putBlob(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.syncbase.BlobRef br)
      throws io.v.v23.verror.VException {

    return this.wrapperBlobManager.putBlob(ctx, call, br);
  }

  /**
   * UnpinBlob locally unpins the blob so that it can be evicted if needed.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> unpinBlob(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.syncbase.BlobRef br)
      throws io.v.v23.verror.VException {

    return this.wrapperBlobManager.unpinBlob(ctx, call, br);
  }

  /**
   * StartConflictResolver registers a resolver for the database that is
   * associated with this ConflictManager and creates a stream to receive
   * conflicts and send resolutions.
   * Batches of ConflictInfos will be sent over with the Continued field
   * within the ConflictInfo representing the batch boundary. Client must
   * respond with a batch of ResolutionInfos in the same fashion.
   * A key is under conflict if two different values were written to it
   * concurrently (in logical time), i.e. neither value is an ancestor of the
   * other in the history graph.
   * A key under conflict can be a part of a batch committed on local or
   * remote or both syncbases. ConflictInfos for all keys in these two batches
   * are grouped together. These keys may themselves be under conflict; the
   * presented batch is a transitive closure of all batches containing keys
   * under conflict.
   * For example, for local batch {key1, key2} and remote batch {key1, key3},
   * the batch sent for conflict resolution will be {key1, key2, key3}.
   * If there was another concurrent batch {key2, key4}, then the batch sent
   * for conflict resolution will be {key1, key2, key3, key4}.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> startConflictResolver(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperConflictManager.startConflictResolver(ctx, call);
  }

  /**
   * GetResumeMarker returns the ResumeMarker that points to the current end
   * of the event log. GetResumeMarker() can be called on a batch.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.watch.ResumeMarker>
      getResumeMarker(
          io.v.v23.context.VContext ctx,
          io.v.v23.rpc.StreamServerCall call,
          final io.v.v23.services.syncbase.BatchHandle bh)
          throws io.v.v23.verror.VException {

    return this.wrapperDatabaseWatcher.getResumeMarker(ctx, call, bh);
  }

  /**
   * WatchPatterns returns a stream of changes that match any of the specified
   * patterns. At least one pattern must be specified.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> watchPatterns(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.watch.ResumeMarker resumeMarker,
      final java.util.List<io.v.v23.services.syncbase.CollectionRowPattern> patterns)
      throws io.v.v23.verror.VException {

    return this.wrapperDatabaseWatcher.watchPatterns(ctx, call, resumeMarker, patterns);
  }

  /**
   * GetSchemaMetadata retrieves schema metadata for this database.
   *<p>
   * Requires: Client must have at least Read access on the Database.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SchemaMetadata>
      getSchemaMetadata(io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
          throws io.v.v23.verror.VException {

    return this.wrapperSchemaManager.getSchemaMetadata(ctx, call);
  }

  /**
   * SetSchemaMetadata stores schema metadata for this database.
   *<p>
   * Requires: Client must have at least Write access on the Database.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSchemaMetadata(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.syncbase.SchemaMetadata metadata)
      throws io.v.v23.verror.VException {

    return this.wrapperSchemaManager.setSchemaMetadata(ctx, call, metadata);
  }

  /**
   * CreateSyncgroup creates a new syncgroup with the given spec.
   *<p>
   * Requires: Client must have at least Read access on the Database; all
   * Collections specified in prefixes must exist; Client must have at least
   * Read access on each of the Collection ACLs.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> createSyncgroup(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo)
      throws io.v.v23.verror.VException {

    return this.wrapperSyncgroupManager.createSyncgroup(ctx, call, sgId, spec, myInfo);
  }

  /**
   * DestroySyncgroup destroys the syncgroup. Previously synced data will
   * continue to be available to all members.
   *<p>
   * Requires: Client must have at least Read access on the Database, and must
   * have Admin access on the syncgroup ACL.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroySyncgroup(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.syncbase.Id sgId)
      throws io.v.v23.verror.VException {

    return this.wrapperSyncgroupManager.destroySyncgroup(ctx, call, sgId);
  }

  /**
   * EjectFromSyncgroup ejects a member from the syncgroup. The ejected member
   * will not be able to sync further, but will retain any data it has already
   * synced.
   *<p>
   * Requires: Client must have at least Read access on the Database, and must
   * have Admin access on the syncgroup ACL.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> ejectFromSyncgroup(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.syncbase.Id sgId,
      final java.lang.String member)
      throws io.v.v23.verror.VException {

    return this.wrapperSyncgroupManager.ejectFromSyncgroup(ctx, call, sgId, member);
  }

  /**
   * GetSyncgroupMembers gets the info objects for members of the syncgroup.
   *<p>
   * Requires: Client must have at least Read access on the Database and on the
   * syncgroup ACL.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>>
      getSyncgroupMembers(
          io.v.v23.context.VContext ctx,
          io.v.v23.rpc.StreamServerCall call,
          final io.v.v23.services.syncbase.Id sgId)
          throws io.v.v23.verror.VException {

    return this.wrapperSyncgroupManager.getSyncgroupMembers(ctx, call, sgId);
  }

  /**
   * GetSyncgroupSpec gets the syncgroup spec. version allows for atomic
   * read-modify-write of the spec - see comment for SetSyncgroupSpec.
   *<p>
   * Requires: Client must have at least Read access on the Database and on the
   * syncgroup ACL.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupManagerServer.GetSyncgroupSpecOut>
      getSyncgroupSpec(
          io.v.v23.context.VContext ctx,
          io.v.v23.rpc.StreamServerCall call,
          final io.v.v23.services.syncbase.Id sgId)
          throws io.v.v23.verror.VException {

    return this.wrapperSyncgroupManager.getSyncgroupSpec(ctx, call, sgId);
  }

  /**
   * JoinSyncgroup joins the syncgroup.
   *<p>
   * Requires: Client must have at least Read access on the Database and on the
   * syncgroup ACL.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupSpec>
      joinSyncgroup(
          io.v.v23.context.VContext ctx,
          io.v.v23.rpc.StreamServerCall call,
          final java.lang.String remoteSyncbaseName,
          final java.util.List<java.lang.String> expectedSyncbaseBlessings,
          final io.v.v23.services.syncbase.Id sgId,
          final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo)
          throws io.v.v23.verror.VException {

    return this
        .wrapperSyncgroupManager.joinSyncgroup(
            ctx, call, remoteSyncbaseName, expectedSyncbaseBlessings, sgId, myInfo);
  }

  /**
   * LeaveSyncgroup leaves the syncgroup. Previously synced data will continue
   * to be available.
   *<p>
   * Requires: Client must have at least Read access on the Database.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> leaveSyncgroup(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.syncbase.Id sgId)
      throws io.v.v23.verror.VException {

    return this.wrapperSyncgroupManager.leaveSyncgroup(ctx, call, sgId);
  }

  /**
   * ListSyncgroups returns the relative syncgroup ids of all syncgroups attached to
   * this database.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.syncbase.Id>>
      listSyncgroups(io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
          throws io.v.v23.verror.VException {

    return this.wrapperSyncgroupManager.listSyncgroups(ctx, call);
  }

  /**
   * SetSyncgroupSpec sets the syncgroup spec. version may be either empty or
   * the value from a previous Get. If not empty, Set will only succeed if the
   * current version matches the specified one.
   *<p>
   * Requires: Client must have at least Read access on the Database, and must
   * have Admin access on the syncgroup ACL.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSyncgroupSpec(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final java.lang.String version)
      throws io.v.v23.verror.VException {

    return this.wrapperSyncgroupManager.setSyncgroupSpec(ctx, call, sgId, spec, version);
  }

  /**
   * WatchGlob returns a stream of changes that match a pattern.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> watchGlob(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.watch.GlobRequest req)
      throws io.v.v23.verror.VException {

    return this.wrapperGlobWatcher.watchGlob(ctx, call, req);
  }
}
