// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.v23.services.syncbase;

/**
 * Implementation of the {@link DatabaseClient} interface.
 */
final class DatabaseClientImpl implements io.v.v23.services.syncbase.DatabaseClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  private final io.v.v23.services.permissions.ObjectClient implObject;

  private final io.v.v23.services.watch.GlobWatcherClient implGlobWatcher;

  private final io.v.v23.services.syncbase.DatabaseWatcherClient implDatabaseWatcher;

  private final io.v.v23.services.syncbase.SyncgroupManagerClient implSyncgroupManager;

  private final io.v.v23.services.syncbase.BlobManagerClient implBlobManager;

  private final io.v.v23.services.syncbase.SchemaManagerClient implSchemaManager;

  private final io.v.v23.services.syncbase.ConflictManagerClient implConflictManager;

  /**
   * Creates a new instance of {@link DatabaseClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public DatabaseClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implObject =
          io.v.v23.services.permissions.ObjectClientFactory.getObjectClient(vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implGlobWatcher =
          io.v.v23.services.watch.GlobWatcherClientFactory.getGlobWatcherClient(vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implDatabaseWatcher =
          io.v.v23.services.syncbase.DatabaseWatcherClientFactory.getDatabaseWatcherClient(
              vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implSyncgroupManager =
          io.v.v23.services.syncbase.SyncgroupManagerClientFactory.getSyncgroupManagerClient(
              vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implBlobManager =
          io.v.v23.services.syncbase.BlobManagerClientFactory.getBlobManagerClient(vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implSchemaManager =
          io.v.v23.services.syncbase.SchemaManagerClientFactory.getSchemaManagerClient(vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implConflictManager =
          io.v.v23.services.syncbase.ConflictManagerClientFactory.getConflictManagerClient(
              vName, opts);
    }
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface DatabaseClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      io.v.v23.context.VContext _context,
      final io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.SchemaMetadata> metadata,
      final io.v.v23.security.access.Permissions perms) {
    return create(_context, metadata, perms, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      final io.v.v23.context.VContext _context,
      final io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.SchemaMetadata> metadata,
      final io.v.v23.security.access.Permissions perms,
      io.v.v23.Options _opts) {
    return create(_context, metadata, perms, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      final io.v.v23.context.VContext _context,
      final io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.SchemaMetadata> metadata,
      final io.v.v23.security.access.Permissions perms,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {metadata, perms};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          new com.google.common.reflect.TypeToken<
              io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.SchemaMetadata>>() {}.getType(),
          new com.google.common.reflect.TypeToken<
              io.v.v23.security.access.Permissions>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "create", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroy(
      io.v.v23.context.VContext _context) {
    return destroy(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroy(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return destroy(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroy(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "destroy", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> exists(
      io.v.v23.context.VContext _context) {
    return exists(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> exists(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return exists(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> exists(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "exists", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Boolean>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Boolean.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Boolean>() {
                      @Override
                      public java.lang.Boolean apply(Object[] _results) {

                        return (java.lang.Boolean) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.syncbase.Id>>
      listCollections(
          io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BatchHandle bh) {
    return listCollections(_context, bh, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.syncbase.Id>>
      listCollections(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BatchHandle bh,
          io.v.v23.Options _opts) {
    return listCollections(_context, bh, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.syncbase.Id>>
      listCollections(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BatchHandle bh,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {bh};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.syncbase.BatchHandle.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "listCollections", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.util.List<io.v.v23.services.syncbase.Id>>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      java.util.List<io.v.v23.services.syncbase.Id>>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      new com.google.common.reflect.TypeToken<
                          java.util.List<io.v.v23.services.syncbase.Id>>() {}.getType(),
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], java.util.List<io.v.v23.services.syncbase.Id>>() {
                      @Override
                      public java.util.List<io.v.v23.services.syncbase.Id> apply(
                          Object[] _results) {

                        return (java.util.List<io.v.v23.services.syncbase.Id>) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<java.util.List<io.v.v23.vdl.VdlAny>, java.lang.Void> exec(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final java.lang.String query,
      final java.util.List<io.v.v23.vdl.VdlAny> params) {
    return exec(_context, bh, query, params, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<java.util.List<io.v.v23.vdl.VdlAny>, java.lang.Void> exec(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final java.lang.String query,
      final java.util.List<io.v.v23.vdl.VdlAny> params,
      io.v.v23.Options _opts) {
    return exec(_context, bh, query, params, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<java.util.List<io.v.v23.vdl.VdlAny>, java.lang.Void> exec(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final java.lang.String query,
      final java.util.List<io.v.v23.vdl.VdlAny> params,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {bh, query, params};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.services.syncbase.BatchHandle.class,
          java.lang.String.class,
          new com.google.common.reflect.TypeToken<
              java.util.List<io.v.v23.vdl.VdlAny>>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "exec", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<
        java.lang.Void, java.util.List<io.v.v23.vdl.VdlAny>, java.lang.Void>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(
          final java.lang.Void item) {
        final java.lang.reflect.Type type = java.lang.Void.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.util.List<io.v.v23.vdl.VdlAny>>
          recv() {
        final java.lang.reflect.Type recvType =
            new com.google.common.reflect.TypeToken<
                java.util.List<io.v.v23.vdl.VdlAny>>() {}.getType();
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.util.List<io.v.v23.vdl.VdlAny>>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<
                          java.util.List<io.v.v23.vdl.VdlAny>>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<
                            Object, java.util.List<io.v.v23.vdl.VdlAny>>() {
                          @Override
                          public java.util.List<io.v.v23.vdl.VdlAny> apply(Object result) {
                            return (java.util.List<io.v.v23.vdl.VdlAny>) result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> finish() {

        final java.lang.reflect.Type[] resultTypes = new java.lang.reflect.Type[] {};

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<Object[], java.lang.Void>() {
                          @Override
                          public java.lang.Void apply(Object[] _results) {

                            return null;
                          }
                        });
                  }
                }));
      }
    };
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.BatchHandle>
      beginBatch(
          io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BatchOptions bo) {
    return beginBatch(_context, bo, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.BatchHandle>
      beginBatch(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BatchOptions bo,
          io.v.v23.Options _opts) {
    return beginBatch(_context, bo, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.BatchHandle>
      beginBatch(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BatchOptions bo,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {bo};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.syncbase.BatchOptions.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "beginBatch", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.services.syncbase.BatchHandle>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.v23.services.syncbase.BatchHandle>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.services.syncbase.BatchHandle.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.v23.services.syncbase.BatchHandle>() {
                      @Override
                      public io.v.v23.services.syncbase.BatchHandle apply(Object[] _results) {

                        return (io.v.v23.services.syncbase.BatchHandle) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> commit(
      io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BatchHandle bh) {
    return commit(_context, bh, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> commit(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      io.v.v23.Options _opts) {
    return commit(_context, bh, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> commit(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {bh};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.syncbase.BatchHandle.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "commit", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> abort(
      io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BatchHandle bh) {
    return abort(_context, bh, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> abort(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      io.v.v23.Options _opts) {
    return abort(_context, bh, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> abort(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {bh};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.syncbase.BatchHandle.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "abort", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> pauseSync(
      io.v.v23.context.VContext _context) {
    return pauseSync(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> pauseSync(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return pauseSync(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> pauseSync(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "pauseSync", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> resumeSync(
      io.v.v23.context.VContext _context) {
    return resumeSync(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> resumeSync(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return resumeSync(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> resumeSync(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "resumeSync", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context) {

    return this.implObject.getPermissions(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implObject.getPermissions(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implObject.getPermissions(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version) {

    return this.implObject.setPermissions(_context, perms, version);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version,
      io.v.v23.Options _opts) {

    return this.implObject.setPermissions(_context, perms, version, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version,
      io.v.v23.options.RpcOptions _opts) {

    return this.implObject.setPermissions(_context, perms, version, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> commitBlob(
      io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BlobRef br) {

    return this.implBlobManager.commitBlob(_context, br);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> commitBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.Options _opts) {

    return this.implBlobManager.commitBlob(_context, br, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> commitBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.options.RpcOptions _opts) {

    return this.implBlobManager.commitBlob(_context, br, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.BlobRef>
      createBlob(io.v.v23.context.VContext _context) {

    return this.implBlobManager.createBlob(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.BlobRef>
      createBlob(io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implBlobManager.createBlob(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.BlobRef>
      createBlob(io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implBlobManager.createBlob(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> deleteBlob(
      io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BlobRef br) {

    return this.implBlobManager.deleteBlob(_context, br);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> deleteBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.Options _opts) {

    return this.implBlobManager.deleteBlob(_context, br, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> deleteBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.options.RpcOptions _opts) {

    return this.implBlobManager.deleteBlob(_context, br, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.syncbase.BlobFetchStatus, java.lang.Void>
      fetchBlob(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BlobRef br,
          final io.v.v23.vdl.VdlUint64 priority) {

    return this.implBlobManager.fetchBlob(_context, br, priority);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.syncbase.BlobFetchStatus, java.lang.Void>
      fetchBlob(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BlobRef br,
          final io.v.v23.vdl.VdlUint64 priority,
          io.v.v23.Options _opts) {

    return this.implBlobManager.fetchBlob(_context, br, priority, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.syncbase.BlobFetchStatus, java.lang.Void>
      fetchBlob(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BlobRef br,
          final io.v.v23.vdl.VdlUint64 priority,
          io.v.v23.options.RpcOptions _opts) {

    return this.implBlobManager.fetchBlob(_context, br, priority, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> getBlobSize(
      io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BlobRef br) {

    return this.implBlobManager.getBlobSize(_context, br);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> getBlobSize(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.Options _opts) {

    return this.implBlobManager.getBlobSize(_context, br, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> getBlobSize(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.options.RpcOptions _opts) {

    return this.implBlobManager.getBlobSize(_context, br, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<byte[], java.lang.Void> getBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      final long offset) {

    return this.implBlobManager.getBlob(_context, br, offset);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<byte[], java.lang.Void> getBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      final long offset,
      io.v.v23.Options _opts) {

    return this.implBlobManager.getBlob(_context, br, offset, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<byte[], java.lang.Void> getBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      final long offset,
      io.v.v23.options.RpcOptions _opts) {

    return this.implBlobManager.getBlob(_context, br, offset, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> keepBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      final io.v.v23.vdl.VdlUint64 rank) {

    return this.implBlobManager.keepBlob(_context, br, rank);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> keepBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      final io.v.v23.vdl.VdlUint64 rank,
      io.v.v23.Options _opts) {

    return this.implBlobManager.keepBlob(_context, br, rank, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> keepBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      final io.v.v23.vdl.VdlUint64 rank,
      io.v.v23.options.RpcOptions _opts) {

    return this.implBlobManager.keepBlob(_context, br, rank, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> pinBlob(
      io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BlobRef br) {

    return this.implBlobManager.pinBlob(_context, br);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> pinBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.Options _opts) {

    return this.implBlobManager.pinBlob(_context, br, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> pinBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.options.RpcOptions _opts) {

    return this.implBlobManager.pinBlob(_context, br, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientSendStream<byte[], java.lang.Void> putBlob(
      io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BlobRef br) {

    return this.implBlobManager.putBlob(_context, br);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientSendStream<byte[], java.lang.Void> putBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.Options _opts) {

    return this.implBlobManager.putBlob(_context, br, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientSendStream<byte[], java.lang.Void> putBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.options.RpcOptions _opts) {

    return this.implBlobManager.putBlob(_context, br, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> unpinBlob(
      io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BlobRef br) {

    return this.implBlobManager.unpinBlob(_context, br);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> unpinBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.Options _opts) {

    return this.implBlobManager.unpinBlob(_context, br, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> unpinBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.options.RpcOptions _opts) {

    return this.implBlobManager.unpinBlob(_context, br, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientStream<
          io.v.v23.services.syncbase.ResolutionInfo, io.v.v23.services.syncbase.ConflictInfo,
          java.lang.Void>
      startConflictResolver(io.v.v23.context.VContext _context) {

    return this.implConflictManager.startConflictResolver(_context);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientStream<
          io.v.v23.services.syncbase.ResolutionInfo, io.v.v23.services.syncbase.ConflictInfo,
          java.lang.Void>
      startConflictResolver(io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implConflictManager.startConflictResolver(_context, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientStream<
          io.v.v23.services.syncbase.ResolutionInfo, io.v.v23.services.syncbase.ConflictInfo,
          java.lang.Void>
      startConflictResolver(io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implConflictManager.startConflictResolver(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.watch.ResumeMarker>
      getResumeMarker(
          io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BatchHandle bh) {

    return this.implDatabaseWatcher.getResumeMarker(_context, bh);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.watch.ResumeMarker>
      getResumeMarker(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BatchHandle bh,
          io.v.v23.Options _opts) {

    return this.implDatabaseWatcher.getResumeMarker(_context, bh, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.watch.ResumeMarker>
      getResumeMarker(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BatchHandle bh,
          io.v.v23.options.RpcOptions _opts) {

    return this.implDatabaseWatcher.getResumeMarker(_context, bh, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void>
      watchPatterns(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.watch.ResumeMarker resumeMarker,
          final java.util.List<io.v.v23.services.syncbase.CollectionRowPattern> patterns) {

    return this.implDatabaseWatcher.watchPatterns(_context, resumeMarker, patterns);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void>
      watchPatterns(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.watch.ResumeMarker resumeMarker,
          final java.util.List<io.v.v23.services.syncbase.CollectionRowPattern> patterns,
          io.v.v23.Options _opts) {

    return this.implDatabaseWatcher.watchPatterns(_context, resumeMarker, patterns, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void>
      watchPatterns(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.watch.ResumeMarker resumeMarker,
          final java.util.List<io.v.v23.services.syncbase.CollectionRowPattern> patterns,
          io.v.v23.options.RpcOptions _opts) {

    return this.implDatabaseWatcher.watchPatterns(_context, resumeMarker, patterns, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SchemaMetadata>
      getSchemaMetadata(io.v.v23.context.VContext _context) {

    return this.implSchemaManager.getSchemaMetadata(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SchemaMetadata>
      getSchemaMetadata(io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implSchemaManager.getSchemaMetadata(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SchemaMetadata>
      getSchemaMetadata(io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implSchemaManager.getSchemaMetadata(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSchemaMetadata(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.SchemaMetadata metadata) {

    return this.implSchemaManager.setSchemaMetadata(_context, metadata);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSchemaMetadata(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.SchemaMetadata metadata,
      io.v.v23.Options _opts) {

    return this.implSchemaManager.setSchemaMetadata(_context, metadata, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSchemaMetadata(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.SchemaMetadata metadata,
      io.v.v23.options.RpcOptions _opts) {

    return this.implSchemaManager.setSchemaMetadata(_context, metadata, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> createSyncgroup(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo) {

    return this.implSyncgroupManager.createSyncgroup(_context, sgId, spec, myInfo);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> createSyncgroup(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo,
      io.v.v23.Options _opts) {

    return this.implSyncgroupManager.createSyncgroup(_context, sgId, spec, myInfo, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> createSyncgroup(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo,
      io.v.v23.options.RpcOptions _opts) {

    return this.implSyncgroupManager.createSyncgroup(_context, sgId, spec, myInfo, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroySyncgroup(
      io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.Id sgId) {

    return this.implSyncgroupManager.destroySyncgroup(_context, sgId);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroySyncgroup(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      io.v.v23.Options _opts) {

    return this.implSyncgroupManager.destroySyncgroup(_context, sgId, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroySyncgroup(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      io.v.v23.options.RpcOptions _opts) {

    return this.implSyncgroupManager.destroySyncgroup(_context, sgId, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> ejectFromSyncgroup(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final java.lang.String member) {

    return this.implSyncgroupManager.ejectFromSyncgroup(_context, sgId, member);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> ejectFromSyncgroup(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final java.lang.String member,
      io.v.v23.Options _opts) {

    return this.implSyncgroupManager.ejectFromSyncgroup(_context, sgId, member, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> ejectFromSyncgroup(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final java.lang.String member,
      io.v.v23.options.RpcOptions _opts) {

    return this.implSyncgroupManager.ejectFromSyncgroup(_context, sgId, member, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>>
      getSyncgroupMembers(
          io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.Id sgId) {

    return this.implSyncgroupManager.getSyncgroupMembers(_context, sgId);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>>
      getSyncgroupMembers(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.Id sgId,
          io.v.v23.Options _opts) {

    return this.implSyncgroupManager.getSyncgroupMembers(_context, sgId, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<java.lang.String, io.v.v23.services.syncbase.SyncgroupMemberInfo>>
      getSyncgroupMembers(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.Id sgId,
          io.v.v23.options.RpcOptions _opts) {

    return this.implSyncgroupManager.getSyncgroupMembers(_context, sgId, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupManagerClient.GetSyncgroupSpecOut>
      getSyncgroupSpec(
          io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.Id sgId) {

    return this.implSyncgroupManager.getSyncgroupSpec(_context, sgId);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupManagerClient.GetSyncgroupSpecOut>
      getSyncgroupSpec(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.Id sgId,
          io.v.v23.Options _opts) {

    return this.implSyncgroupManager.getSyncgroupSpec(_context, sgId, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupManagerClient.GetSyncgroupSpecOut>
      getSyncgroupSpec(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.Id sgId,
          io.v.v23.options.RpcOptions _opts) {

    return this.implSyncgroupManager.getSyncgroupSpec(_context, sgId, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupSpec>
      joinSyncgroup(
          io.v.v23.context.VContext _context,
          final java.lang.String remoteSyncbaseName,
          final java.util.List<java.lang.String> expectedSyncbaseBlessings,
          final io.v.v23.services.syncbase.Id sgId,
          final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo) {

    return this
        .implSyncgroupManager.joinSyncgroup(
            _context, remoteSyncbaseName, expectedSyncbaseBlessings, sgId, myInfo);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupSpec>
      joinSyncgroup(
          io.v.v23.context.VContext _context,
          final java.lang.String remoteSyncbaseName,
          final java.util.List<java.lang.String> expectedSyncbaseBlessings,
          final io.v.v23.services.syncbase.Id sgId,
          final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo,
          io.v.v23.Options _opts) {

    return this
        .implSyncgroupManager.joinSyncgroup(
            _context, remoteSyncbaseName, expectedSyncbaseBlessings, sgId, myInfo, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.syncbase.SyncgroupSpec>
      joinSyncgroup(
          io.v.v23.context.VContext _context,
          final java.lang.String remoteSyncbaseName,
          final java.util.List<java.lang.String> expectedSyncbaseBlessings,
          final io.v.v23.services.syncbase.Id sgId,
          final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo,
          io.v.v23.options.RpcOptions _opts) {

    return this
        .implSyncgroupManager.joinSyncgroup(
            _context, remoteSyncbaseName, expectedSyncbaseBlessings, sgId, myInfo, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> leaveSyncgroup(
      io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.Id sgId) {

    return this.implSyncgroupManager.leaveSyncgroup(_context, sgId);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> leaveSyncgroup(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      io.v.v23.Options _opts) {

    return this.implSyncgroupManager.leaveSyncgroup(_context, sgId, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> leaveSyncgroup(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      io.v.v23.options.RpcOptions _opts) {

    return this.implSyncgroupManager.leaveSyncgroup(_context, sgId, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.syncbase.Id>>
      listSyncgroups(io.v.v23.context.VContext _context) {

    return this.implSyncgroupManager.listSyncgroups(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.syncbase.Id>>
      listSyncgroups(io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implSyncgroupManager.listSyncgroups(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.syncbase.Id>>
      listSyncgroups(io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implSyncgroupManager.listSyncgroups(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSyncgroupSpec(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final java.lang.String version) {

    return this.implSyncgroupManager.setSyncgroupSpec(_context, sgId, spec, version);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSyncgroupSpec(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final java.lang.String version,
      io.v.v23.Options _opts) {

    return this.implSyncgroupManager.setSyncgroupSpec(_context, sgId, spec, version, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setSyncgroupSpec(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.Id sgId,
      final io.v.v23.services.syncbase.SyncgroupSpec spec,
      final java.lang.String version,
      io.v.v23.options.RpcOptions _opts) {

    return this.implSyncgroupManager.setSyncgroupSpec(_context, sgId, spec, version, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void> watchGlob(
      io.v.v23.context.VContext _context, final io.v.v23.services.watch.GlobRequest req) {

    return this.implGlobWatcher.watchGlob(_context, req);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void> watchGlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.watch.GlobRequest req,
      io.v.v23.Options _opts) {

    return this.implGlobWatcher.watchGlob(_context, req, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void> watchGlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.watch.GlobRequest req,
      io.v.v23.options.RpcOptions _opts) {

    return this.implGlobWatcher.watchGlob(_context, req, _opts);
  }
}
