// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: service.vdl
package io.v.v23.services.syncbase;

/**
 * Database represents a set of Collections. Batches, queries, syncgroups, and
 * watch all operate at the Database level.
 * Database.Glob operates over Collection ids.
 */
public interface DatabaseClient
    extends io.v.v23.services.permissions.ObjectClient,
        io.v.v23.services.syncbase.DatabaseWatcherClient,
        io.v.v23.services.syncbase.SyncgroupManagerClient,
        io.v.v23.services.syncbase.BlobManagerClient,
        io.v.v23.services.syncbase.SchemaManagerClient,
        io.v.v23.services.syncbase.ConflictManagerClient {

  /**
   * Create creates this Database. Permissions must be non-nil and include at
   * least one admin.
   * Create requires the caller to have Write permission at the Service.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      io.v.v23.context.VContext context,
      final io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.SchemaMetadata> metadata,
      final io.v.v23.security.access.Permissions perms);

  /**
   * Create creates this Database. Permissions must be non-nil and include at
   * least one admin.
   * Create requires the caller to have Write permission at the Service.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      io.v.v23.context.VContext context,
      final io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.SchemaMetadata> metadata,
      final io.v.v23.security.access.Permissions perms,
      io.v.v23.Options opts);

  /**
   * Create creates this Database. Permissions must be non-nil and include at
   * least one admin.
   * Create requires the caller to have Write permission at the Service.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      io.v.v23.context.VContext context,
      final io.v.v23.vdl.VdlOptional<io.v.v23.services.syncbase.SchemaMetadata> metadata,
      final io.v.v23.security.access.Permissions perms,
      io.v.v23.options.RpcOptions opts);

  /**
   * Destroy destroys this Database, permanently removing all of its data.
   * TODO(sadovsky): Specify what happens to syncgroups.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroy(
      io.v.v23.context.VContext context);

  /**
   * Destroy destroys this Database, permanently removing all of its data.
   * TODO(sadovsky): Specify what happens to syncgroups.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroy(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * Destroy destroys this Database, permanently removing all of its data.
   * TODO(sadovsky): Specify what happens to syncgroups.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroy(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * Exists returns true only if this Database exists. Insufficient permissions
   * cause Exists to return false instead of an error.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> exists(
      io.v.v23.context.VContext context);

  /**
   * Exists returns true only if this Database exists. Insufficient permissions
   * cause Exists to return false instead of an error.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> exists(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * Exists returns true only if this Database exists. Insufficient permissions
   * cause Exists to return false instead of an error.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> exists(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * ListCollections returns an unsorted list of all Collection ids that the
   * caller is allowed to see.
   * This method exists on Database but not on Service because for the latter
   * we can simply use glob, while for the former glob lists only Collections
   * visible in a new snapshot of the Database, ignoring user batches.
   * (Note that the same issue is present in glob on Collection, where Scan can
   * be used instead if batch awareness is required.)
   * Note, the glob client library checks Resolve access on every component
   * along the path (by doing a Dispatcher.Lookup), whereas this doesn't happen
   * for other RPCs.
   * TODO(ivanpi): Resolve should be checked on all RPCs.
   * TODO(sadovsky): Maybe switch to streaming RPC.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.util.List<io.v.v23.services.syncbase.Id>>
      listCollections(
          io.v.v23.context.VContext context, final io.v.v23.services.syncbase.BatchHandle bh);

  /**
   * ListCollections returns an unsorted list of all Collection ids that the
   * caller is allowed to see.
   * This method exists on Database but not on Service because for the latter
   * we can simply use glob, while for the former glob lists only Collections
   * visible in a new snapshot of the Database, ignoring user batches.
   * (Note that the same issue is present in glob on Collection, where Scan can
   * be used instead if batch awareness is required.)
   * Note, the glob client library checks Resolve access on every component
   * along the path (by doing a Dispatcher.Lookup), whereas this doesn't happen
   * for other RPCs.
   * TODO(ivanpi): Resolve should be checked on all RPCs.
   * TODO(sadovsky): Maybe switch to streaming RPC.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.util.List<io.v.v23.services.syncbase.Id>>
      listCollections(
          io.v.v23.context.VContext context,
          final io.v.v23.services.syncbase.BatchHandle bh,
          io.v.v23.Options opts);

  /**
   * ListCollections returns an unsorted list of all Collection ids that the
   * caller is allowed to see.
   * This method exists on Database but not on Service because for the latter
   * we can simply use glob, while for the former glob lists only Collections
   * visible in a new snapshot of the Database, ignoring user batches.
   * (Note that the same issue is present in glob on Collection, where Scan can
   * be used instead if batch awareness is required.)
   * Note, the glob client library checks Resolve access on every component
   * along the path (by doing a Dispatcher.Lookup), whereas this doesn't happen
   * for other RPCs.
   * TODO(ivanpi): Resolve should be checked on all RPCs.
   * TODO(sadovsky): Maybe switch to streaming RPC.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.util.List<io.v.v23.services.syncbase.Id>>
      listCollections(
          io.v.v23.context.VContext context,
          final io.v.v23.services.syncbase.BatchHandle bh,
          io.v.v23.options.RpcOptions opts);

  /**
   * Exec executes a syncQL query with positional parameters and returns all
   * results as specified by the query's select/delete statement.
   * Concurrency semantics are documented in model.go.
   */
  io.v.v23.vdl.ClientRecvStream<java.util.List<io.v.v23.vdl.VdlAny>, java.lang.Void> exec(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final java.lang.String query,
      final java.util.List<io.v.v23.vdl.VdlAny> params);

  /**
   * Exec executes a syncQL query with positional parameters and returns all
   * results as specified by the query's select/delete statement.
   * Concurrency semantics are documented in model.go.
   */
  @java.lang.Deprecated
  io.v.v23.vdl.ClientRecvStream<java.util.List<io.v.v23.vdl.VdlAny>, java.lang.Void> exec(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final java.lang.String query,
      final java.util.List<io.v.v23.vdl.VdlAny> params,
      io.v.v23.Options opts);

  /**
   * Exec executes a syncQL query with positional parameters and returns all
   * results as specified by the query's select/delete statement.
   * Concurrency semantics are documented in model.go.
   */
  io.v.v23.vdl.ClientRecvStream<java.util.List<io.v.v23.vdl.VdlAny>, java.lang.Void> exec(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final java.lang.String query,
      final java.util.List<io.v.v23.vdl.VdlAny> params,
      io.v.v23.options.RpcOptions opts);

  /**
   * BeginBatch creates a new batch. It returns a batch handle to pass in when
   * calling batch-aware RPCs.
   * Concurrency semantics are documented in model.go.
   * All batch-aware RPCs can also be called outside a batch (with an empty
   * handle), with the exception of Commit and Abort which only make sense on
   * a batch. Note that glob RPCs are not batch-aware.
   * TODO(sadovsky): Maybe make BatchOptions optional. Also, rename 'bo' to
   * 'opts' once v.io/i/912 is resolved for Java.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.BatchHandle>
      beginBatch(
          io.v.v23.context.VContext context, final io.v.v23.services.syncbase.BatchOptions bo);

  /**
   * BeginBatch creates a new batch. It returns a batch handle to pass in when
   * calling batch-aware RPCs.
   * Concurrency semantics are documented in model.go.
   * All batch-aware RPCs can also be called outside a batch (with an empty
   * handle), with the exception of Commit and Abort which only make sense on
   * a batch. Note that glob RPCs are not batch-aware.
   * TODO(sadovsky): Maybe make BatchOptions optional. Also, rename 'bo' to
   * 'opts' once v.io/i/912 is resolved for Java.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.BatchHandle>
      beginBatch(
          io.v.v23.context.VContext context,
          final io.v.v23.services.syncbase.BatchOptions bo,
          io.v.v23.Options opts);

  /**
   * BeginBatch creates a new batch. It returns a batch handle to pass in when
   * calling batch-aware RPCs.
   * Concurrency semantics are documented in model.go.
   * All batch-aware RPCs can also be called outside a batch (with an empty
   * handle), with the exception of Commit and Abort which only make sense on
   * a batch. Note that glob RPCs are not batch-aware.
   * TODO(sadovsky): Maybe make BatchOptions optional. Also, rename 'bo' to
   * 'opts' once v.io/i/912 is resolved for Java.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.BatchHandle>
      beginBatch(
          io.v.v23.context.VContext context,
          final io.v.v23.services.syncbase.BatchOptions bo,
          io.v.v23.options.RpcOptions opts);

  /**
   * Commit persists the pending changes to the database.
   * If the batch is readonly, Commit() will fail with ErrReadOnlyBatch; Abort()
   * should be used instead.
   * If the BatchHandle is empty, Commit() will fail with ErrNotBoundToBatch.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> commit(
      io.v.v23.context.VContext context, final io.v.v23.services.syncbase.BatchHandle bh);

  /**
   * Commit persists the pending changes to the database.
   * If the batch is readonly, Commit() will fail with ErrReadOnlyBatch; Abort()
   * should be used instead.
   * If the BatchHandle is empty, Commit() will fail with ErrNotBoundToBatch.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> commit(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      io.v.v23.Options opts);

  /**
   * Commit persists the pending changes to the database.
   * If the batch is readonly, Commit() will fail with ErrReadOnlyBatch; Abort()
   * should be used instead.
   * If the BatchHandle is empty, Commit() will fail with ErrNotBoundToBatch.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> commit(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      io.v.v23.options.RpcOptions opts);

  /**
   * Abort notifies the server that any pending changes can be discarded.
   * It is not strictly required, but it may allow the server to release locks
   * or other resources sooner than if it was not called.
   * If the BatchHandle is empty, Abort() will fail with ErrNotBoundToBatch.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> abort(
      io.v.v23.context.VContext context, final io.v.v23.services.syncbase.BatchHandle bh);

  /**
   * Abort notifies the server that any pending changes can be discarded.
   * It is not strictly required, but it may allow the server to release locks
   * or other resources sooner than if it was not called.
   * If the BatchHandle is empty, Abort() will fail with ErrNotBoundToBatch.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> abort(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      io.v.v23.Options opts);

  /**
   * Abort notifies the server that any pending changes can be discarded.
   * It is not strictly required, but it may allow the server to release locks
   * or other resources sooner than if it was not called.
   * If the BatchHandle is empty, Abort() will fail with ErrNotBoundToBatch.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> abort(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      io.v.v23.options.RpcOptions opts);

  /**
   * PauseSync pauses sync for this database. Incoming sync, as well as outgoing
   * sync of subsequent writes, will be disabled until ResumeSync is called.
   * PauseSync is idempotent.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> pauseSync(
      io.v.v23.context.VContext context);

  /**
   * PauseSync pauses sync for this database. Incoming sync, as well as outgoing
   * sync of subsequent writes, will be disabled until ResumeSync is called.
   * PauseSync is idempotent.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> pauseSync(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * PauseSync pauses sync for this database. Incoming sync, as well as outgoing
   * sync of subsequent writes, will be disabled until ResumeSync is called.
   * PauseSync is idempotent.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> pauseSync(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * ResumeSync resumes sync for this database. ResumeSync is idempotent.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> resumeSync(
      io.v.v23.context.VContext context);

  /**
   * ResumeSync resumes sync for this database. ResumeSync is idempotent.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> resumeSync(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * ResumeSync resumes sync for this database. ResumeSync is idempotent.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> resumeSync(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);
}
