// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

/**
 * CrRule provides a filter and the type of resolution to perform for a row
 * under conflict that passes the filter.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.CrRule")
public class CrRule extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "CollectionId", index = 0)
  private io.v.v23.services.syncbase.Id collectionId;

  @io.v.v23.vdl.GeneratedFromVdl(name = "KeyPrefix", index = 1)
  private java.lang.String keyPrefix;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Type", index = 2)
  private java.lang.String type;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Resolver", index = 3)
  private io.v.v23.services.syncbase.ResolverType resolver;

  /**
   * Vdl type for {@link CrRule}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(CrRule.class);

  /**
   * Creates a new zero-value instance of {@link CrRule}.
   */
  public CrRule() {
    super(VDL_TYPE);

    this.collectionId = new io.v.v23.services.syncbase.Id();

    this.keyPrefix = "";

    this.type = "";

    this.resolver = io.v.v23.services.syncbase.ResolverType.LastWins;
  }

  /**
   * Creates a new instance of {@link CrRule} with the provided field values.
   */
  public CrRule(
      io.v.v23.services.syncbase.Id collectionId,
      java.lang.String keyPrefix,
      java.lang.String type,
      io.v.v23.services.syncbase.ResolverType resolver) {
    super(VDL_TYPE);

    this.collectionId = collectionId;

    this.keyPrefix = keyPrefix;

    this.type = type;

    this.resolver = resolver;
  }

  /**
   * CollectionId is the id of the collection that this rule applies to.
   */
  public io.v.v23.services.syncbase.Id getCollectionId() {
    return this.collectionId;
  }

  /**
   * CollectionId is the id of the collection that this rule applies to.
   */
  public void setCollectionId(io.v.v23.services.syncbase.Id collectionId) {
    this.collectionId = collectionId;
  }

  /**
   * KeyPrefix represents the set of keys within the given collection for which
   * this policy applies. CollectionId must not be empty if this field is set.
   */
  public java.lang.String getKeyPrefix() {
    return this.keyPrefix;
  }

  /**
   * KeyPrefix represents the set of keys within the given collection for which
   * this policy applies. CollectionId must not be empty if this field is set.
   */
  public void setKeyPrefix(java.lang.String keyPrefix) {
    this.keyPrefix = keyPrefix;
  }

  /**
   * Type includes the full package path for the value type for which this
   * policy applies.
   */
  public java.lang.String getType() {
    return this.type;
  }

  /**
   * Type includes the full package path for the value type for which this
   * policy applies.
   */
  public void setType(java.lang.String type) {
    this.type = type;
  }

  /**
   * Policy for resolving conflict.
   */
  public io.v.v23.services.syncbase.ResolverType getResolver() {
    return this.resolver;
  }

  /**
   * Policy for resolving conflict.
   */
  public void setResolver(io.v.v23.services.syncbase.ResolverType resolver) {
    this.resolver = resolver;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    CrRule other = (CrRule) obj;

    if (this.collectionId == null) {
      if (other.collectionId != null) {
        return false;
      }
    } else if (!this.collectionId.equals(other.collectionId)) {
      return false;
    }

    if (this.keyPrefix == null) {
      if (other.keyPrefix != null) {
        return false;
      }
    } else if (!this.keyPrefix.equals(other.keyPrefix)) {
      return false;
    }

    if (this.type == null) {
      if (other.type != null) {
        return false;
      }
    } else if (!this.type.equals(other.type)) {
      return false;
    }

    if (this.resolver == null) {
      if (other.resolver != null) {
        return false;
      }
    } else if (!this.resolver.equals(other.resolver)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.collectionId == null ? 0 : this.collectionId.hashCode());

    result = prime * result + (this.keyPrefix == null ? 0 : this.keyPrefix.hashCode());

    result = prime * result + (this.type == null ? 0 : this.type.hashCode());

    result = prime * result + (this.resolver == null ? 0 : this.resolver.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "collectionId:" + this.collectionId;

    result += ", ";

    result += "keyPrefix:" + this.keyPrefix;

    result += ", ";

    result += "type:" + this.type;

    result += ", ";

    result += "resolver:" + this.resolver;

    return result + "}";
  }
}
