// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

/**
 * For a given row with a conflict, all rules are matched against the row.
 * If no rules match the row, we default to "LastWins". If multiple
 * rules match the row, ties are broken as follows:
 *  1. If one match has a longer prefix than the other, take that one.
 *  2. Else, if only one match specifies a type, take that one.
 *  3. Else, the two matches are identical; take the last one in the Rules array.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.CrPolicy")
public class CrPolicy extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Rules", index = 0)
  private java.util.List<io.v.v23.services.syncbase.CrRule> rules;

  /**
   * Vdl type for {@link CrPolicy}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(CrPolicy.class);

  /**
   * Creates a new zero-value instance of {@link CrPolicy}.
   */
  public CrPolicy() {
    super(VDL_TYPE);

    this.rules = new java.util.ArrayList<io.v.v23.services.syncbase.CrRule>();
  }

  /**
   * Creates a new instance of {@link CrPolicy} with the provided field values.
   */
  public CrPolicy(java.util.List<io.v.v23.services.syncbase.CrRule> rules) {
    super(VDL_TYPE);

    this.rules = rules;
  }

  public java.util.List<io.v.v23.services.syncbase.CrRule> getRules() {
    return this.rules;
  }

  public void setRules(java.util.List<io.v.v23.services.syncbase.CrRule> rules) {
    this.rules = rules;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    CrPolicy other = (CrPolicy) obj;

    if (this.rules == null) {
      if (other.rules != null) {
        return false;
      }
    } else if (!this.rules.equals(other.rules)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.rules == null ? 0 : this.rules.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "rules:" + this.rules;

    return result + "}";
  }
}
