// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s): service.vdl, types.vdl
package io.v.v23.services.syncbase;

/**
 * Constants defined in all VDL files in this package.
 */
public final class Constants {

  /* The following constants originate in file: service.vdl */

  /**
   * Access tags used in Syncbase database ACLs.
   */
  public static final java.util.List<io.v.v23.security.access.Tag> ALL_DATABASE_TAGS =
      new com.google.common.collect.ImmutableList.Builder<io.v.v23.security.access.Tag>()
          .add(new io.v.v23.security.access.Tag("Admin"))
          .add(new io.v.v23.security.access.Tag("Read"))
          .add(new io.v.v23.security.access.Tag("Write"))
          .add(new io.v.v23.security.access.Tag("Resolve"))
          .build();

  /**
   * Access tags used in Syncbase collection ACLs.
   */
  public static final java.util.List<io.v.v23.security.access.Tag> ALL_COLLECTION_TAGS =
      new com.google.common.collect.ImmutableList.Builder<io.v.v23.security.access.Tag>()
          .add(new io.v.v23.security.access.Tag("Admin"))
          .add(new io.v.v23.security.access.Tag("Read"))
          .add(new io.v.v23.security.access.Tag("Write"))
          .build();

  /**
   * Access tags used in Syncbase syncgroup ACLs.
   */
  public static final java.util.List<io.v.v23.security.access.Tag> ALL_SYNCGROUP_TAGS =
      new com.google.common.collect.ImmutableList.Builder<io.v.v23.security.access.Tag>()
          .add(new io.v.v23.security.access.Tag("Admin"))
          .add(new io.v.v23.security.access.Tag("Read"))
          .build();

  /* The following constants originate in file: types.vdl */

  /**
   * Blobs migrate toward servers, which store them.  (example: server in cloud)
   */
  public static final int BLOB_DEV_TYPE_SERVER = 0;

  /**
   * Ordinary devices (example: laptop)
   */
  public static final int BLOB_DEV_TYPE_NORMAL = 1;

  /**
   * Blobs migrate from leaves, which have less storage (examples: a camera, phone)
   */
  public static final int BLOB_DEV_TYPE_LEAF = 2;

  public static final io.v.v23.services.syncbase.BlobRef NULL_BLOB_REF =
      new io.v.v23.services.syncbase.BlobRef();

  /**
   * DiscoveryAttrPeer is the globally unique identifier of the advertised syncbase.
   */
  public static final java.lang.String DISCOVERY_ATTR_PEER = "p";

  /**
   * DiscoveryAttrSyncgroupName is the name of the advertised syncgroup.
   */
  public static final java.lang.String DISCOVERY_ATTR_SYNCGROUP_NAME = "s";

  /**
   * DiscoveryAttrSyncgroupBlessing is the blessing of the creator of the syncgroup.
   */
  public static final java.lang.String DISCOVERY_ATTR_SYNCGROUP_BLESSING = "sb";

  /**
   * DiscoveryAttrDatabaseName is the name component of a database ID, that this syncgroup is a part of.
   */
  public static final java.lang.String DISCOVERY_ATTR_DATABASE_NAME = "d";

  /**
   * DiscoveryAttrDatabaseBlessing is the app blessing component of a database ID,
   * that this syncgroup is a part of.
   */
  public static final java.lang.String DISCOVERY_ATTR_DATABASE_BLESSING = "db";

  private Constants() {}
}
