// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.v23.services.syncbase;

/**
 * Wrapper for {@link ConflictManagerServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class ConflictManagerServerWrapper {
  private final io.v.v23.services.syncbase.ConflictManagerServer server;

  /**
   * Creates a new {@link ConflictManagerServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public ConflictManagerServerWrapper(io.v.v23.services.syncbase.ConflictManagerServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "startConflictResolver",
              "// StartConflictResolver registers a resolver for the database that is"
                  + "// associated with this ConflictManager and creates a stream to receive"
                  + "// conflicts and send resolutions."
                  + "// Batches of ConflictInfos will be sent over with the Continued field"
                  + "// within the ConflictInfo representing the batch boundary. Client must"
                  + "// respond with a batch of ResolutionInfos in the same fashion."
                  + "// A key is under conflict if two different values were written to it"
                  + "// concurrently (in logical time), i.e. neither value is an ancestor of the"
                  + "// other in the history graph."
                  + "// A key under conflict can be a part of a batch committed on local or"
                  + "// remote or both syncbases. ConflictInfos for all keys in these two batches"
                  + "// are grouped together. These keys may themselves be under conflict; the"
                  + "// presented batch is a transitive closure of all batches containing keys"
                  + "// under conflict."
                  + "// For example, for local batch {key1, key2} and remote batch {key1, key3},"
                  + "// the batch sent for conflict resolution will be {key1, key2, key3}."
                  + "// If there was another concurrent batch {key2, key4}, then the batch sent"
                  + "// for conflict resolution will be {key1, key2, key3, key4}."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "ConflictManager",
        "io.v.v23.services.syncbase",
        "// ConflictManager interface provides all the methods necessary to handle"
            + "// conflict resolution for a given database."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("startConflictResolver".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format(
                "Couldn't get tags for method \"startConflictResolver\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * StartConflictResolver registers a resolver for the database that is
   * associated with this ConflictManager and creates a stream to receive
   * conflicts and send resolutions.
   * Batches of ConflictInfos will be sent over with the Continued field
   * within the ConflictInfo representing the batch boundary. Client must
   * respond with a batch of ResolutionInfos in the same fashion.
   * A key is under conflict if two different values were written to it
   * concurrently (in logical time), i.e. neither value is an ancestor of the
   * other in the history graph.
   * A key under conflict can be a part of a batch committed on local or
   * remote or both syncbases. ConflictInfos for all keys in these two batches
   * are grouped together. These keys may themselves be under conflict; the
   * presented batch is a transitive closure of all batches containing keys
   * under conflict.
   * For example, for local batch {key1, key2} and remote batch {key1, key3},
   * the batch sent for conflict resolution will be {key1, key2, key3}.
   * If there was another concurrent batch {key2, key4}, then the batch sent
   * for conflict resolution will be {key1, key2, key3, key4}.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> startConflictResolver(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    io.v.v23.vdl.ServerStream<
            io.v.v23.services.syncbase.ConflictInfo, io.v.v23.services.syncbase.ResolutionInfo>
        _stream =
            new io.v.v23.vdl.ServerStream<
                io.v.v23.services.syncbase.ConflictInfo,
                io.v.v23.services.syncbase.ResolutionInfo>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<Void> send(
                  io.v.v23.services.syncbase.ConflictInfo _item) {
                java.lang.reflect.Type _type = io.v.v23.services.syncbase.ConflictInfo.class;
                return _call.send(_item, _type);
              }

              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.v23.services.syncbase.ResolutionInfo>
                  recv() {
                java.lang.reflect.Type _type = io.v.v23.services.syncbase.ResolutionInfo.class;
                return com.google.common.util.concurrent.Futures.transform(
                    _call.recv(_type),
                    new com.google.common.base.Function<
                        Object, io.v.v23.services.syncbase.ResolutionInfo>() {
                      @Override
                      public io.v.v23.services.syncbase.ResolutionInfo apply(Object result) {
                        return (io.v.v23.services.syncbase.ResolutionInfo) result;
                      }
                    });
              }
            };

    return this.server.startConflictResolver(_ctx, _call, _stream);
  }
}
