// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: service.vdl
package io.v.v23.services.syncbase;

/**
 * ConflictManager interface provides all the methods necessary to handle
 * conflict resolution for a given database.
 */
public interface ConflictManagerClient {

  /**
   * StartConflictResolver registers a resolver for the database that is
   * associated with this ConflictManager and creates a stream to receive
   * conflicts and send resolutions.
   * Batches of ConflictInfos will be sent over with the Continued field
   * within the ConflictInfo representing the batch boundary. Client must
   * respond with a batch of ResolutionInfos in the same fashion.
   * A key is under conflict if two different values were written to it
   * concurrently (in logical time), i.e. neither value is an ancestor of the
   * other in the history graph.
   * A key under conflict can be a part of a batch committed on local or
   * remote or both syncbases. ConflictInfos for all keys in these two batches
   * are grouped together. These keys may themselves be under conflict; the
   * presented batch is a transitive closure of all batches containing keys
   * under conflict.
   * For example, for local batch {key1, key2} and remote batch {key1, key3},
   * the batch sent for conflict resolution will be {key1, key2, key3}.
   * If there was another concurrent batch {key2, key4}, then the batch sent
   * for conflict resolution will be {key1, key2, key3, key4}.
   */
  io.v.v23.vdl.ClientStream<
          io.v.v23.services.syncbase.ResolutionInfo, io.v.v23.services.syncbase.ConflictInfo,
          java.lang.Void>
      startConflictResolver(io.v.v23.context.VContext context);

  /**
   * StartConflictResolver registers a resolver for the database that is
   * associated with this ConflictManager and creates a stream to receive
   * conflicts and send resolutions.
   * Batches of ConflictInfos will be sent over with the Continued field
   * within the ConflictInfo representing the batch boundary. Client must
   * respond with a batch of ResolutionInfos in the same fashion.
   * A key is under conflict if two different values were written to it
   * concurrently (in logical time), i.e. neither value is an ancestor of the
   * other in the history graph.
   * A key under conflict can be a part of a batch committed on local or
   * remote or both syncbases. ConflictInfos for all keys in these two batches
   * are grouped together. These keys may themselves be under conflict; the
   * presented batch is a transitive closure of all batches containing keys
   * under conflict.
   * For example, for local batch {key1, key2} and remote batch {key1, key3},
   * the batch sent for conflict resolution will be {key1, key2, key3}.
   * If there was another concurrent batch {key2, key4}, then the batch sent
   * for conflict resolution will be {key1, key2, key3, key4}.
   */
  @java.lang.Deprecated
  io.v.v23.vdl.ClientStream<
          io.v.v23.services.syncbase.ResolutionInfo, io.v.v23.services.syncbase.ConflictInfo,
          java.lang.Void>
      startConflictResolver(io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * StartConflictResolver registers a resolver for the database that is
   * associated with this ConflictManager and creates a stream to receive
   * conflicts and send resolutions.
   * Batches of ConflictInfos will be sent over with the Continued field
   * within the ConflictInfo representing the batch boundary. Client must
   * respond with a batch of ResolutionInfos in the same fashion.
   * A key is under conflict if two different values were written to it
   * concurrently (in logical time), i.e. neither value is an ancestor of the
   * other in the history graph.
   * A key under conflict can be a part of a batch committed on local or
   * remote or both syncbases. ConflictInfos for all keys in these two batches
   * are grouped together. These keys may themselves be under conflict; the
   * presented batch is a transitive closure of all batches containing keys
   * under conflict.
   * For example, for local batch {key1, key2} and remote batch {key1, key3},
   * the batch sent for conflict resolution will be {key1, key2, key3}.
   * If there was another concurrent batch {key2, key4}, then the batch sent
   * for conflict resolution will be {key1, key2, key3, key4}.
   */
  io.v.v23.vdl.ClientStream<
          io.v.v23.services.syncbase.ResolutionInfo, io.v.v23.services.syncbase.ConflictInfo,
          java.lang.Void>
      startConflictResolver(io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);
}
