// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

/**
 * ConflictInfo contains information to fully specify a conflict
 * for a key, providing the (local, remote, ancestor) tuple.
 * A key under conflict can be a part of a batch in local, remote or both
 * updates. Since the batches can have more than one key, all ConflictInfos
 * for the keys within the batches are grouped together into a single conflict
 * batch and sent as a stream with the Continued field representing conflict
 * batch boundaries.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.ConflictInfo")
public class ConflictInfo extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Data", index = 0)
  private io.v.v23.services.syncbase.ConflictData data;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Continued", index = 1)
  private boolean continued;

  /**
   * Vdl type for {@link ConflictInfo}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(ConflictInfo.class);

  /**
   * Creates a new zero-value instance of {@link ConflictInfo}.
   */
  public ConflictInfo() {
    super(VDL_TYPE);

    this.data = new io.v.v23.services.syncbase.ConflictData.Batch();

    this.continued = false;
  }

  /**
   * Creates a new instance of {@link ConflictInfo} with the provided field values.
   */
  public ConflictInfo(io.v.v23.services.syncbase.ConflictData data, boolean continued) {
    super(VDL_TYPE);

    this.data = data;

    this.continued = continued;
  }

  /**
   * Data is a unit chunk of ConflictInfo which can be sent over the conflict
   * stream.
   */
  public io.v.v23.services.syncbase.ConflictData getData() {
    return this.data;
  }

  /**
   * Data is a unit chunk of ConflictInfo which can be sent over the conflict
   * stream.
   */
  public void setData(io.v.v23.services.syncbase.ConflictData data) {
    this.data = data;
  }

  /**
   * Continued represents whether the batch of ConflictInfos has ended.
   */
  public boolean getContinued() {
    return this.continued;
  }

  /**
   * Continued represents whether the batch of ConflictInfos has ended.
   */
  public void setContinued(boolean continued) {
    this.continued = continued;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    ConflictInfo other = (ConflictInfo) obj;

    if (this.data == null) {
      if (other.data != null) {
        return false;
      }
    } else if (!this.data.equals(other.data)) {
      return false;
    }

    if (this.continued != other.continued) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.data == null ? 0 : this.data.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.continued).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "data:" + this.data;

    result += ", ";

    result += "continued:" + this.continued;

    return result + "}";
  }
}
