// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: service.vdl
package io.v.v23.services.syncbase;

/**
 * Collection represents a set of Rows.
 * Collection.Glob operates over keys of Rows in the Collection.
 */
@io.v.v23.vdl.VServer(serverWrapper = io.v.v23.services.syncbase.CollectionServerWrapper.class)
public interface CollectionServer {

  /**
   * Create creates this Collection. Permissions must be non-nil and include at
   * least one admin.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final io.v.v23.security.access.Permissions perms);

  /**
   * Destroy destroys this Collection, permanently removing all of its data.
   * TODO(sadovsky): Specify what happens to syncgroups.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroy(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.v23.services.syncbase.BatchHandle bh);

  /**
   * Exists returns true only if this Collection exists. Insufficient
   * permissions cause Exists to return false instead of an error.
   * TODO(ivanpi): Exists may fail with an error if higher levels of hierarchy
   * do not exist.
   * TODO(ivanpi): Temporarily set to Read access because Resolve is now invalid
   * on Collection.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> exists(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.v23.services.syncbase.BatchHandle bh);

  /**
   * GetPermissions returns the current Permissions for the Collection.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.access.Permissions>
      getPermissions(
          io.v.v23.context.VContext context,
          io.v.v23.rpc.ServerCall call,
          final io.v.v23.services.syncbase.BatchHandle bh);

  /**
   * SetPermissions replaces the current Permissions for the Collection.
   * Permissions must include at least one admin.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final io.v.v23.security.access.Permissions perms);

  /**
   * DeleteRange deletes all rows in the given half-open range [start, limit).
   * If limit is "", all rows with keys >= start are included.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> deleteRange(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final byte[] start,
      final byte[] limit);

  /**
   * Scan returns all rows in the given half-open range [start, limit). If limit
   * is "", all rows with keys >= start are included.
   * Concurrency semantics are documented in model.go.
   * Note, we use []byte rather than string for start and limit because they
   * need not be valid UTF-8; VDL expects strings to be valid UTF-8.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> scan(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final byte[] start,
      final byte[] limit,
      io.v.v23.vdl.ServerSendStream<io.v.v23.services.syncbase.KeyValue> stream);
}
