// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.v23.services.syncbase;

/**
 * Implementation of the {@link CollectionClient} interface.
 */
final class CollectionClientImpl implements io.v.v23.services.syncbase.CollectionClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  /**
   * Creates a new instance of {@link CollectionClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public CollectionClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface CollectionClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final io.v.v23.security.access.Permissions perms) {
    return create(_context, bh, perms, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final io.v.v23.security.access.Permissions perms,
      io.v.v23.Options _opts) {
    return create(_context, bh, perms, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final io.v.v23.security.access.Permissions perms,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {bh, perms};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.services.syncbase.BatchHandle.class,
          new com.google.common.reflect.TypeToken<
              io.v.v23.security.access.Permissions>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "create", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroy(
      io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BatchHandle bh) {
    return destroy(_context, bh, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroy(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      io.v.v23.Options _opts) {
    return destroy(_context, bh, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> destroy(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {bh};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.syncbase.BatchHandle.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "destroy", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> exists(
      io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BatchHandle bh) {
    return exists(_context, bh, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> exists(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      io.v.v23.Options _opts) {
    return exists(_context, bh, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> exists(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {bh};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.syncbase.BatchHandle.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "exists", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Boolean>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Boolean.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Boolean>() {
                      @Override
                      public java.lang.Boolean apply(Object[] _results) {

                        return (java.lang.Boolean) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.access.Permissions>
      getPermissions(
          io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BatchHandle bh) {
    return getPermissions(_context, bh, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.access.Permissions>
      getPermissions(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BatchHandle bh,
          io.v.v23.Options _opts) {
    return getPermissions(_context, bh, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.access.Permissions>
      getPermissions(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BatchHandle bh,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {bh};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.syncbase.BatchHandle.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "getPermissions", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.security.access.Permissions>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.v23.security.access.Permissions>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      new com.google.common.reflect.TypeToken<
                          io.v.v23.security.access.Permissions>() {}.getType(),
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.v23.security.access.Permissions>() {
                      @Override
                      public io.v.v23.security.access.Permissions apply(Object[] _results) {

                        return (io.v.v23.security.access.Permissions) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final io.v.v23.security.access.Permissions perms) {
    return setPermissions(_context, bh, perms, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final io.v.v23.security.access.Permissions perms,
      io.v.v23.Options _opts) {
    return setPermissions(_context, bh, perms, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final io.v.v23.security.access.Permissions perms,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {bh, perms};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.services.syncbase.BatchHandle.class,
          new com.google.common.reflect.TypeToken<
              io.v.v23.security.access.Permissions>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "setPermissions", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> deleteRange(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final byte[] start,
      final byte[] limit) {
    return deleteRange(_context, bh, start, limit, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> deleteRange(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final byte[] start,
      final byte[] limit,
      io.v.v23.Options _opts) {
    return deleteRange(
        _context, bh, start, limit, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> deleteRange(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final byte[] start,
      final byte[] limit,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {bh, start, limit};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.services.syncbase.BatchHandle.class, byte[].class, byte[].class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "deleteRange", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.syncbase.KeyValue, java.lang.Void> scan(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final byte[] start,
      final byte[] limit) {
    return scan(_context, bh, start, limit, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.syncbase.KeyValue, java.lang.Void> scan(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final byte[] start,
      final byte[] limit,
      io.v.v23.Options _opts) {
    return scan(_context, bh, start, limit, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.syncbase.KeyValue, java.lang.Void> scan(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BatchHandle bh,
      final byte[] start,
      final byte[] limit,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {bh, start, limit};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.services.syncbase.BatchHandle.class, byte[].class, byte[].class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "scan", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<
        java.lang.Void, io.v.v23.services.syncbase.KeyValue, java.lang.Void>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(
          final java.lang.Void item) {
        final java.lang.reflect.Type type = java.lang.Void.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.KeyValue>
          recv() {
        final java.lang.reflect.Type recvType = io.v.v23.services.syncbase.KeyValue.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, io.v.v23.services.syncbase.KeyValue>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<
                          io.v.v23.services.syncbase.KeyValue>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<
                            Object, io.v.v23.services.syncbase.KeyValue>() {
                          @Override
                          public io.v.v23.services.syncbase.KeyValue apply(Object result) {
                            return (io.v.v23.services.syncbase.KeyValue) result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> finish() {

        final java.lang.reflect.Type[] resultTypes = new java.lang.reflect.Type[] {};

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<Object[], java.lang.Void>() {
                          @Override
                          public java.lang.Void apply(Object[] _results) {

                            return null;
                          }
                        });
                  }
                }));
      }
    };
  }
}
