// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.v23.services.syncbase;

/**
 * Wrapper for {@link BlobManagerServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class BlobManagerServerWrapper {
  private final io.v.v23.services.syncbase.BlobManagerServer server;

  /**
   * Creates a new {@link BlobManagerServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public BlobManagerServerWrapper(io.v.v23.services.syncbase.BlobManagerServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BlobRef.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "createBlob",
              "// CreateBlob returns a BlobRef for a newly created blob." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BlobRef.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "putBlob",
              "// PutBlob appends the byte stream to the blob." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BlobRef.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "commitBlob",
              "// CommitBlob marks the blob as immutable." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BlobRef.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Long.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "getBlobSize",
              "// GetBlobSize returns the count of bytes written as part of the blob"
                  + "// (committed or uncommitted)."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BlobRef.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "deleteBlob",
              "// DeleteBlob locally deletes the blob (committed or uncommitted)." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BlobRef.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Long.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "getBlob",
              "// GetBlob returns the byte stream from a committed blob starting at offset." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BlobRef.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlUint64.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "fetchBlob",
              "// FetchBlob initiates fetching a blob if not locally found. priority"
                  + "// controls the network priority of the blob. Higher priority blobs are"
                  + "// fetched before the lower priority ones. However, an ongoing blob"
                  + "// transfer is not interrupted. Status updates are streamed back to the"
                  + "// client as fetch is in progress."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BlobRef.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "pinBlob",
              "// PinBlob locally pins the blob so that it is not evicted." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BlobRef.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "unpinBlob",
              "// UnpinBlob locally unpins the blob so that it can be evicted if needed." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BlobRef.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlUint64.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "keepBlob",
              "// KeepBlob locally caches the blob with the specified rank. Lower"
                  + "// ranked blobs are more eagerly evicted."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "BlobManager",
        "io.v.v23.services.syncbase",
        "// BlobManager is the interface for blob operations."
            + "//"
            + "// Description of API for resumable blob creation (append-only):"
            + "// - Up until commit, a BlobRef may be used with PutBlob, GetBlobSize,"
            + "//   DeleteBlob, and CommitBlob. Blob creation may be resumed by obtaining the"
            + "//   current blob size via GetBlobSize and appending to the blob via PutBlob."
            + "// - After commit, a blob is immutable, at which point PutBlob and CommitBlob"
            + "//   may no longer be used."
            + "// - All other methods (GetBlob, FetchBlob, PinBlob, etc.) may only be used"
            + "//   after commit."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("commitBlob".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"commitBlob\": %s", e.getMessage()));
      }
    }

    if ("createBlob".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"createBlob\": %s", e.getMessage()));
      }
    }

    if ("deleteBlob".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"deleteBlob\": %s", e.getMessage()));
      }
    }

    if ("fetchBlob".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"fetchBlob\": %s", e.getMessage()));
      }
    }

    if ("getBlob".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"getBlob\": %s", e.getMessage()));
      }
    }

    if ("getBlobSize".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"getBlobSize\": %s", e.getMessage()));
      }
    }

    if ("keepBlob".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"keepBlob\": %s", e.getMessage()));
      }
    }

    if ("pinBlob".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"pinBlob\": %s", e.getMessage()));
      }
    }

    if ("putBlob".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"putBlob\": %s", e.getMessage()));
      }
    }

    if ("unpinBlob".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"unpinBlob\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * CreateBlob returns a BlobRef for a newly created blob.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.BlobRef>
      createBlob(io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.createBlob(_ctx, _call);
  }

  /**
   * PutBlob appends the byte stream to the blob.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> putBlob(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.BlobRef br) {

    io.v.v23.vdl.ServerStream<java.lang.Void, byte[]> _stream =
        new io.v.v23.vdl.ServerStream<java.lang.Void, byte[]>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(
              java.lang.Void _item) {
            java.lang.reflect.Type _type = java.lang.Void.class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<byte[]> recv() {
            java.lang.reflect.Type _type = byte[].class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, byte[]>() {
                  @Override
                  public byte[] apply(Object result) {
                    return (byte[]) result;
                  }
                });
          }
        };

    return this.server.putBlob(_ctx, _call, br, _stream);
  }

  /**
   * CommitBlob marks the blob as immutable.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> commitBlob(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.BlobRef br) {

    return this.server.commitBlob(_ctx, _call, br);
  }

  /**
   * GetBlobSize returns the count of bytes written as part of the blob
   * (committed or uncommitted).
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> getBlobSize(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.BlobRef br) {

    return this.server.getBlobSize(_ctx, _call, br);
  }

  /**
   * DeleteBlob locally deletes the blob (committed or uncommitted).
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> deleteBlob(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.BlobRef br) {

    return this.server.deleteBlob(_ctx, _call, br);
  }

  /**
   * GetBlob returns the byte stream from a committed blob starting at offset.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> getBlob(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.BlobRef br,
      final long offset) {

    io.v.v23.vdl.ServerStream<byte[], java.lang.Void> _stream =
        new io.v.v23.vdl.ServerStream<byte[], java.lang.Void>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(byte[] _item) {
            java.lang.reflect.Type _type = byte[].class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> recv() {
            java.lang.reflect.Type _type = java.lang.Void.class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, java.lang.Void>() {
                  @Override
                  public java.lang.Void apply(Object result) {
                    return (java.lang.Void) result;
                  }
                });
          }
        };

    return this.server.getBlob(_ctx, _call, br, offset, _stream);
  }

  /**
   * FetchBlob initiates fetching a blob if not locally found. priority
   * controls the network priority of the blob. Higher priority blobs are
   * fetched before the lower priority ones. However, an ongoing blob
   * transfer is not interrupted. Status updates are streamed back to the
   * client as fetch is in progress.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> fetchBlob(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.BlobRef br,
      final io.v.v23.vdl.VdlUint64 priority) {

    io.v.v23.vdl.ServerStream<io.v.v23.services.syncbase.BlobFetchStatus, java.lang.Void> _stream =
        new io.v.v23.vdl.ServerStream<
            io.v.v23.services.syncbase.BlobFetchStatus, java.lang.Void>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(
              io.v.v23.services.syncbase.BlobFetchStatus _item) {
            java.lang.reflect.Type _type = io.v.v23.services.syncbase.BlobFetchStatus.class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> recv() {
            java.lang.reflect.Type _type = java.lang.Void.class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, java.lang.Void>() {
                  @Override
                  public java.lang.Void apply(Object result) {
                    return (java.lang.Void) result;
                  }
                });
          }
        };

    return this.server.fetchBlob(_ctx, _call, br, priority, _stream);
  }

  /**
   * PinBlob locally pins the blob so that it is not evicted.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> pinBlob(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.BlobRef br) {

    return this.server.pinBlob(_ctx, _call, br);
  }

  /**
   * UnpinBlob locally unpins the blob so that it can be evicted if needed.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> unpinBlob(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.BlobRef br) {

    return this.server.unpinBlob(_ctx, _call, br);
  }

  /**
   * KeepBlob locally caches the blob with the specified rank. Lower
   * ranked blobs are more eagerly evicted.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> keepBlob(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.BlobRef br,
      final io.v.v23.vdl.VdlUint64 rank) {

    return this.server.keepBlob(_ctx, _call, br, rank);
  }
}
