// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: service.vdl
package io.v.v23.services.syncbase;

/**
 * BlobManager is the interface for blob operations.
 *<p>
 * Description of API for resumable blob creation (append-only):
 * - Up until commit, a BlobRef may be used with PutBlob, GetBlobSize,
 *   DeleteBlob, and CommitBlob. Blob creation may be resumed by obtaining the
 *   current blob size via GetBlobSize and appending to the blob via PutBlob.
 * - After commit, a blob is immutable, at which point PutBlob and CommitBlob
 *   may no longer be used.
 * - All other methods (GetBlob, FetchBlob, PinBlob, etc.) may only be used
 *   after commit.
 */
public interface BlobManagerClient {

  /**
   * CreateBlob returns a BlobRef for a newly created blob.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.BlobRef> createBlob(
      io.v.v23.context.VContext context);

  /**
   * CreateBlob returns a BlobRef for a newly created blob.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.BlobRef> createBlob(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * CreateBlob returns a BlobRef for a newly created blob.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.syncbase.BlobRef> createBlob(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * PutBlob appends the byte stream to the blob.
   */
  io.v.v23.vdl.ClientSendStream<byte[], java.lang.Void> putBlob(
      io.v.v23.context.VContext context, final io.v.v23.services.syncbase.BlobRef br);

  /**
   * PutBlob appends the byte stream to the blob.
   */
  @java.lang.Deprecated
  io.v.v23.vdl.ClientSendStream<byte[], java.lang.Void> putBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.Options opts);

  /**
   * PutBlob appends the byte stream to the blob.
   */
  io.v.v23.vdl.ClientSendStream<byte[], java.lang.Void> putBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.options.RpcOptions opts);

  /**
   * CommitBlob marks the blob as immutable.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> commitBlob(
      io.v.v23.context.VContext context, final io.v.v23.services.syncbase.BlobRef br);

  /**
   * CommitBlob marks the blob as immutable.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> commitBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.Options opts);

  /**
   * CommitBlob marks the blob as immutable.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> commitBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.options.RpcOptions opts);

  /**
   * GetBlobSize returns the count of bytes written as part of the blob
   * (committed or uncommitted).
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Long> getBlobSize(
      io.v.v23.context.VContext context, final io.v.v23.services.syncbase.BlobRef br);

  /**
   * GetBlobSize returns the count of bytes written as part of the blob
   * (committed or uncommitted).
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Long> getBlobSize(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.Options opts);

  /**
   * GetBlobSize returns the count of bytes written as part of the blob
   * (committed or uncommitted).
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Long> getBlobSize(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.options.RpcOptions opts);

  /**
   * DeleteBlob locally deletes the blob (committed or uncommitted).
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> deleteBlob(
      io.v.v23.context.VContext context, final io.v.v23.services.syncbase.BlobRef br);

  /**
   * DeleteBlob locally deletes the blob (committed or uncommitted).
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> deleteBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.Options opts);

  /**
   * DeleteBlob locally deletes the blob (committed or uncommitted).
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> deleteBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.options.RpcOptions opts);

  /**
   * GetBlob returns the byte stream from a committed blob starting at offset.
   */
  io.v.v23.vdl.ClientRecvStream<byte[], java.lang.Void> getBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      final long offset);

  /**
   * GetBlob returns the byte stream from a committed blob starting at offset.
   */
  @java.lang.Deprecated
  io.v.v23.vdl.ClientRecvStream<byte[], java.lang.Void> getBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      final long offset,
      io.v.v23.Options opts);

  /**
   * GetBlob returns the byte stream from a committed blob starting at offset.
   */
  io.v.v23.vdl.ClientRecvStream<byte[], java.lang.Void> getBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      final long offset,
      io.v.v23.options.RpcOptions opts);

  /**
   * FetchBlob initiates fetching a blob if not locally found. priority
   * controls the network priority of the blob. Higher priority blobs are
   * fetched before the lower priority ones. However, an ongoing blob
   * transfer is not interrupted. Status updates are streamed back to the
   * client as fetch is in progress.
   */
  io.v.v23.vdl.ClientRecvStream<io.v.v23.services.syncbase.BlobFetchStatus, java.lang.Void>
      fetchBlob(
          io.v.v23.context.VContext context,
          final io.v.v23.services.syncbase.BlobRef br,
          final io.v.v23.vdl.VdlUint64 priority);

  /**
   * FetchBlob initiates fetching a blob if not locally found. priority
   * controls the network priority of the blob. Higher priority blobs are
   * fetched before the lower priority ones. However, an ongoing blob
   * transfer is not interrupted. Status updates are streamed back to the
   * client as fetch is in progress.
   */
  @java.lang.Deprecated
  io.v.v23.vdl.ClientRecvStream<io.v.v23.services.syncbase.BlobFetchStatus, java.lang.Void>
      fetchBlob(
          io.v.v23.context.VContext context,
          final io.v.v23.services.syncbase.BlobRef br,
          final io.v.v23.vdl.VdlUint64 priority,
          io.v.v23.Options opts);

  /**
   * FetchBlob initiates fetching a blob if not locally found. priority
   * controls the network priority of the blob. Higher priority blobs are
   * fetched before the lower priority ones. However, an ongoing blob
   * transfer is not interrupted. Status updates are streamed back to the
   * client as fetch is in progress.
   */
  io.v.v23.vdl.ClientRecvStream<io.v.v23.services.syncbase.BlobFetchStatus, java.lang.Void>
      fetchBlob(
          io.v.v23.context.VContext context,
          final io.v.v23.services.syncbase.BlobRef br,
          final io.v.v23.vdl.VdlUint64 priority,
          io.v.v23.options.RpcOptions opts);

  /**
   * PinBlob locally pins the blob so that it is not evicted.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> pinBlob(
      io.v.v23.context.VContext context, final io.v.v23.services.syncbase.BlobRef br);

  /**
   * PinBlob locally pins the blob so that it is not evicted.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> pinBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.Options opts);

  /**
   * PinBlob locally pins the blob so that it is not evicted.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> pinBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.options.RpcOptions opts);

  /**
   * UnpinBlob locally unpins the blob so that it can be evicted if needed.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> unpinBlob(
      io.v.v23.context.VContext context, final io.v.v23.services.syncbase.BlobRef br);

  /**
   * UnpinBlob locally unpins the blob so that it can be evicted if needed.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> unpinBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.Options opts);

  /**
   * UnpinBlob locally unpins the blob so that it can be evicted if needed.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> unpinBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      io.v.v23.options.RpcOptions opts);

  /**
   * KeepBlob locally caches the blob with the specified rank. Lower
   * ranked blobs are more eagerly evicted.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> keepBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      final io.v.v23.vdl.VdlUint64 rank);

  /**
   * KeepBlob locally caches the blob with the specified rank. Lower
   * ranked blobs are more eagerly evicted.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> keepBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      final io.v.v23.vdl.VdlUint64 rank,
      io.v.v23.Options opts);

  /**
   * KeepBlob locally caches the blob with the specified rank. Lower
   * ranked blobs are more eagerly evicted.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> keepBlob(
      io.v.v23.context.VContext context,
      final io.v.v23.services.syncbase.BlobRef br,
      final io.v.v23.vdl.VdlUint64 rank,
      io.v.v23.options.RpcOptions opts);
}
