// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

/**
 * BlobFetchStatus describes the progress of an asynchronous blob fetch.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.BlobFetchStatus")
public class BlobFetchStatus extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "State", index = 0)
  private io.v.v23.services.syncbase.BlobFetchState state;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Received", index = 1)
  private long received;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Total", index = 2)
  private long total;

  /**
   * Vdl type for {@link BlobFetchStatus}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(BlobFetchStatus.class);

  /**
   * Creates a new zero-value instance of {@link BlobFetchStatus}.
   */
  public BlobFetchStatus() {
    super(VDL_TYPE);

    this.state = io.v.v23.services.syncbase.BlobFetchState.Pending;

    this.received = 0L;

    this.total = 0L;
  }

  /**
   * Creates a new instance of {@link BlobFetchStatus} with the provided field values.
   */
  public BlobFetchStatus(
      io.v.v23.services.syncbase.BlobFetchState state, long received, long total) {
    super(VDL_TYPE);

    this.state = state;

    this.received = received;

    this.total = total;
  }

  /**
   * State of the blob fetch request.
   */
  public io.v.v23.services.syncbase.BlobFetchState getState() {
    return this.state;
  }

  /**
   * State of the blob fetch request.
   */
  public void setState(io.v.v23.services.syncbase.BlobFetchState state) {
    this.state = state;
  }

  /**
   * Total number of bytes received.
   */
  public long getReceived() {
    return this.received;
  }

  /**
   * Total number of bytes received.
   */
  public void setReceived(long received) {
    this.received = received;
  }

  /**
   * Blob size.
   */
  public long getTotal() {
    return this.total;
  }

  /**
   * Blob size.
   */
  public void setTotal(long total) {
    this.total = total;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    BlobFetchStatus other = (BlobFetchStatus) obj;

    if (this.state == null) {
      if (other.state != null) {
        return false;
      }
    } else if (!this.state.equals(other.state)) {
      return false;
    }

    if (this.received != other.received) {
      return false;
    }

    if (this.total != other.total) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.state == null ? 0 : this.state.hashCode());

    result = prime * result + java.lang.Long.valueOf(this.received).hashCode();

    result = prime * result + java.lang.Long.valueOf(this.total).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "state:" + this.state;

    result += ", ";

    result += "received:" + this.received;

    result += ", ";

    result += "total:" + this.total;

    return result + "}";
  }
}
