// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

/**
 * BatchOptions configures a batch.
 * TODO(sadovsky): Add more options, e.g. to configure isolation, timeouts,
 * whether to track the read set and/or write set, etc.
 * TODO(sadovsky): Maybe add a DefaultBatchOptions() function that initializes
 * BatchOptions with our desired defaults. Clients would be encouraged to
 * initialize their BatchOptions object using that function and then modify it
 * to their liking.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.BatchOptions")
public class BatchOptions extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Hint", index = 0)
  private java.lang.String hint;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ReadOnly", index = 1)
  private boolean readOnly;

  /**
   * Vdl type for {@link BatchOptions}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(BatchOptions.class);

  /**
   * Creates a new zero-value instance of {@link BatchOptions}.
   */
  public BatchOptions() {
    super(VDL_TYPE);

    this.hint = "";

    this.readOnly = false;
  }

  /**
   * Creates a new instance of {@link BatchOptions} with the provided field values.
   */
  public BatchOptions(java.lang.String hint, boolean readOnly) {
    super(VDL_TYPE);

    this.hint = hint;

    this.readOnly = readOnly;
  }

  /**
   * Arbitrary string, typically used to describe the intent behind a batch.
   * Hints are surfaced to clients during conflict resolution.
   * TODO(sadovsky): Use "any" here?
   */
  public java.lang.String getHint() {
    return this.hint;
  }

  /**
   * Arbitrary string, typically used to describe the intent behind a batch.
   * Hints are surfaced to clients during conflict resolution.
   * TODO(sadovsky): Use "any" here?
   */
  public void setHint(java.lang.String hint) {
    this.hint = hint;
  }

  /**
   * ReadOnly specifies whether the batch should allow writes.
   * If ReadOnly is set to true, Abort() should be used to release any resources
   * associated with this batch (though it is not strictly required), and
   * Commit() will always fail.
   */
  public boolean getReadOnly() {
    return this.readOnly;
  }

  /**
   * ReadOnly specifies whether the batch should allow writes.
   * If ReadOnly is set to true, Abort() should be used to release any resources
   * associated with this batch (though it is not strictly required), and
   * Commit() will always fail.
   */
  public void setReadOnly(boolean readOnly) {
    this.readOnly = readOnly;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    BatchOptions other = (BatchOptions) obj;

    if (this.hint == null) {
      if (other.hint != null) {
        return false;
      }
    } else if (!this.hint.equals(other.hint)) {
      return false;
    }

    if (this.readOnly != other.readOnly) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.hint == null ? 0 : this.hint.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.readOnly).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "hint:" + this.hint;

    result += ", ";

    result += "readOnly:" + this.readOnly;

    return result + "}";
  }
}
