// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.services.syncbase;

@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/syncbase.BatchInfo")
public class BatchInfo extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Id", index = 0)
  private io.v.v23.vdl.VdlUint64 id;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Hint", index = 1)
  private java.lang.String hint;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Source", index = 2)
  private io.v.v23.services.syncbase.BatchSource source;

  /**
   * Vdl type for {@link BatchInfo}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(BatchInfo.class);

  /**
   * Creates a new zero-value instance of {@link BatchInfo}.
   */
  public BatchInfo() {
    super(VDL_TYPE);

    this.id = new io.v.v23.vdl.VdlUint64();

    this.hint = "";

    this.source = io.v.v23.services.syncbase.BatchSource.Local;
  }

  /**
   * Creates a new instance of {@link BatchInfo} with the provided field values.
   */
  public BatchInfo(
      io.v.v23.vdl.VdlUint64 id,
      java.lang.String hint,
      io.v.v23.services.syncbase.BatchSource source) {
    super(VDL_TYPE);

    this.id = id;

    this.hint = hint;

    this.source = source;
  }

  /**
   * Id is an identifier for a batch contained in a conflict. It is
   * unique only in the context of a given conflict. Its purpose is solely to
   * group one or more RowInfo objects together to represent a batch that
   * was committed by the client.
   */
  public io.v.v23.vdl.VdlUint64 getId() {
    return this.id;
  }

  /**
   * Id is an identifier for a batch contained in a conflict. It is
   * unique only in the context of a given conflict. Its purpose is solely to
   * group one or more RowInfo objects together to represent a batch that
   * was committed by the client.
   */
  public void setId(io.v.v23.vdl.VdlUint64 id) {
    this.id = id;
  }

  /**
   * Hint is the hint provided by the client when this batch was committed.
   */
  public java.lang.String getHint() {
    return this.hint;
  }

  /**
   * Hint is the hint provided by the client when this batch was committed.
   */
  public void setHint(java.lang.String hint) {
    this.hint = hint;
  }

  /**
   * Source states where the batch comes from.
   */
  public io.v.v23.services.syncbase.BatchSource getSource() {
    return this.source;
  }

  /**
   * Source states where the batch comes from.
   */
  public void setSource(io.v.v23.services.syncbase.BatchSource source) {
    this.source = source;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    BatchInfo other = (BatchInfo) obj;

    if (this.id == null) {
      if (other.id != null) {
        return false;
      }
    } else if (!this.id.equals(other.id)) {
      return false;
    }

    if (this.hint == null) {
      if (other.hint != null) {
        return false;
      }
    } else if (!this.hint.equals(other.hint)) {
      return false;
    }

    if (this.source == null) {
      if (other.source != null) {
        return false;
      }
    } else if (!this.source.equals(other.source)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.id == null ? 0 : this.id.hashCode());

    result = prime * result + (this.hint == null ? 0 : this.hint.hashCode());

    result = prime * result + (this.source == null ? 0 : this.source.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "id:" + this.id;

    result += ", ";

    result += "hint:" + this.hint;

    result += ", ";

    result += "source:" + this.source;

    return result + "}";
  }
}
