// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  stats.vdl
package io.v.v23.services.stats;

/**
 * Wrapper for {@link StatsServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class StatsServerWrapper {
  private final io.v.v23.services.stats.StatsServer server;

  private final io.v.v23.services.watch.GlobWatcherServerWrapper wrapperGlobWatcher;

  /**
   * Creates a new {@link StatsServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public StatsServerWrapper(io.v.v23.services.stats.StatsServer server) {
    this.server = server;

    this.wrapperGlobWatcher = new io.v.v23.services.watch.GlobWatcherServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlAny.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "value",
              "// Value returns the current value of an object, or an error. The type"
                  + "// of the value is implementation specific."
                  + "// Some objects may not have a value, in which case, Value() returns"
                  + "// a NoValue error."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Stats",
        "io.v.v23.services.stats",
        "// The Stats interface is used to access stats for troubleshooting and"
            + "// monitoring purposes. The stats objects are discoverable via the Globbable"
            + "// interface and watchable via the GlobWatcher interface."
            + "//"
            + "// The types of the object values are implementation specific, but should be"
            + "// primarily numeric in nature, e.g. counters, memory usage, latency metrics,"
            + "// etc."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("value".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"value\": %s", e.getMessage()));
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperGlobWatcher.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  /**
   * Value returns the current value of an object, or an error. The type
   * of the value is implementation specific.
   * Some objects may not have a value, in which case, Value() returns
   * a NoValue error.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> value(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.value(_ctx, _call);
  }

  /**
   * WatchGlob returns a stream of changes that match a pattern.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> watchGlob(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.services.watch.GlobRequest req)
      throws io.v.v23.verror.VException {

    return this.wrapperGlobWatcher.watchGlob(ctx, call, req);
  }
}
