// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  stats.vdl
package io.v.v23.services.stats;

/**
 * Implementation of the {@link StatsClient} interface.
 */
final class StatsClientImpl implements io.v.v23.services.stats.StatsClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  private final io.v.v23.services.watch.GlobWatcherClient implGlobWatcher;

  /**
   * Creates a new instance of {@link StatsClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public StatsClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implGlobWatcher =
          io.v.v23.services.watch.GlobWatcherClientFactory.getGlobWatcherClient(vName, opts);
    }
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface StatsClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> value(
      io.v.v23.context.VContext _context) {
    return value(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> value(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return value(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> value(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "value", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.vdl.VdlAny>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.vdl.VdlAny.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], io.v.v23.vdl.VdlAny>() {
                      @Override
                      public io.v.v23.vdl.VdlAny apply(Object[] _results) {

                        return (io.v.v23.vdl.VdlAny) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void> watchGlob(
      io.v.v23.context.VContext _context, final io.v.v23.services.watch.GlobRequest req) {

    return this.implGlobWatcher.watchGlob(_context, req);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void> watchGlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.watch.GlobRequest req,
      io.v.v23.Options _opts) {

    return this.implGlobWatcher.watchGlob(_context, req, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.watch.Change, java.lang.Void> watchGlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.watch.GlobRequest req,
      io.v.v23.options.RpcOptions _opts) {

    return this.implGlobWatcher.watchGlob(_context, req, _opts);
  }
}
