// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: repository.vdl
package io.v.v23.services.repository;

/**
 * Profile abstracts a device's ability to run binaries, and hides
 * specifics such as the operating system, hardware architecture, and
 * the set of installed libraries. Profiles describe binaries and
 * devices, and are used to match them.
 */
public interface ProfileClient {

  /**
   * Label is the human-readable profile key for the profile,
   * e.g. "linux-media". The label can be used to uniquely identify
   * the profile (for the purpose of matching application binaries and
   * devices).
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.String> label(
      io.v.v23.context.VContext context);

  /**
   * Label is the human-readable profile key for the profile,
   * e.g. "linux-media". The label can be used to uniquely identify
   * the profile (for the purpose of matching application binaries and
   * devices).
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.String> label(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * Label is the human-readable profile key for the profile,
   * e.g. "linux-media". The label can be used to uniquely identify
   * the profile (for the purpose of matching application binaries and
   * devices).
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.String> label(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * Description is a free-text description of the profile, meant for
   * human consumption.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.String> description(
      io.v.v23.context.VContext context);

  /**
   * Description is a free-text description of the profile, meant for
   * human consumption.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.String> description(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * Description is a free-text description of the profile, meant for
   * human consumption.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.String> description(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);
}
