// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  repository.vdl
package io.v.v23.services.repository;

/**
 * Wrapper for {@link BinaryServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class BinaryServerWrapper {
  private final io.v.v23.services.repository.BinaryServer server;

  private final io.v.v23.services.permissions.ObjectServerWrapper wrapperObject;

  /**
   * Creates a new {@link BinaryServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public BinaryServerWrapper(io.v.v23.services.repository.BinaryServer server) {
    this.server = server;

    this.wrapperObject = new io.v.v23.services.permissions.ObjectServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.repository.MediaInfo.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "create",
              "// Create expresses the intent to create a binary identified by the"
                  + "// object name suffix consisting of the given number of parts. The"
                  + "// mediaInfo argument contains metadata for the binary. If the suffix"
                  + "// identifies a binary that has already been created, the method"
                  + "// returns an error."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "delete",
              "// Delete deletes the binary identified by the object name"
                  + "// suffix. If the binary that has not been created, the method"
                  + "// returns an error."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "download",
              "// Download opens a stream that can used for downloading the given"
                  + "// part of the binary identified by the object name suffix. If the"
                  + "// binary part has not been uploaded, the method returns an"
                  + "// error. If the Delete() method is invoked when the Download()"
                  + "// method is in progress, the outcome the Download() method is"
                  + "// undefined."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Long.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "downloadUrl",
              "// DownloadUrl returns a transient URL from which the binary"
                  + "// identified by the object name suffix can be downloaded using the"
                  + "// HTTP protocol. If not all parts of the binary have been uploaded,"
                  + "// the method returns an error."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<io.v.v23.services.binary.PartInfo>>() {}.getType())));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.repository.MediaInfo.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "stat",
              "// Stat returns information describing the parts of the binary"
                  + "// identified by the object name suffix, and its RFC 2046 media type."
                  + "// If the binary has not been created, the method returns an error."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "upload",
              "// Upload opens a stream that can be used for uploading the given"
                  + "// part of the binary identified by the object name suffix. If the"
                  + "// binary has not been created, the method returns an error. If the"
                  + "// binary part has been uploaded, the method returns an error. If"
                  + "// the same binary part is being uploaded by another caller, the"
                  + "// method returns an error."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Binary",
        "io.v.v23.services.repository",
        "// Binary can be used to store and retrieve vanadium application"
            + "// binaries."
            + "//"
            + "// To create a binary, clients first invoke the Create() method that"
            + "// specifies the number of parts the binary consists of. Clients then"
            + "// uploads the individual parts through the Upload() method, which"
            + "// identifies the part being uploaded. To resume an upload after a"
            + "// failure, clients invoke the UploadStatus() method, which returns a"
            + "// slice that identifies which parts are missing."
            + "//"
            + "// To download a binary, clients first invoke Stat(), which returns"
            + "// information describing the binary, including the number of parts"
            + "// the binary consists of. Clients then download the individual parts"
            + "// through the Download() method, which identifies the part being"
            + "// downloaded. Alternatively, clients can download the binary through"
            + "// HTTP using a transient URL available through the DownloadUrl()"
            + "// method."
            + "//"
            + "// To delete the binary, clients invoke the Delete() method."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("create".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"create\": %s", e.getMessage()));
      }
    }

    if ("delete".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"delete\": %s", e.getMessage()));
      }
    }

    if ("download".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"download\": %s", e.getMessage()));
      }
    }

    if ("downloadUrl".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"downloadUrl\": %s", e.getMessage()));
      }
    }

    if ("stat".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"stat\": %s", e.getMessage()));
      }
    }

    if ("upload".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"upload\": %s", e.getMessage()));
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperObject.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  /**
   * Create expresses the intent to create a binary identified by the
   * object name suffix consisting of the given number of parts. The
   * mediaInfo argument contains metadata for the binary. If the suffix
   * identifies a binary that has already been created, the method
   * returns an error.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final int nparts,
      final io.v.v23.services.repository.MediaInfo mediaInfo) {

    return this.server.create(_ctx, _call, nparts, mediaInfo);
  }

  /**
   * Delete deletes the binary identified by the object name
   * suffix. If the binary that has not been created, the method
   * returns an error.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.delete(_ctx, _call);
  }

  /**
   * Download opens a stream that can used for downloading the given
   * part of the binary identified by the object name suffix. If the
   * binary part has not been uploaded, the method returns an
   * error. If the Delete() method is invoked when the Download()
   * method is in progress, the outcome the Download() method is
   * undefined.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> download(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call, final int part) {

    io.v.v23.vdl.ServerStream<byte[], java.lang.Void> _stream =
        new io.v.v23.vdl.ServerStream<byte[], java.lang.Void>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(byte[] _item) {
            java.lang.reflect.Type _type = byte[].class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> recv() {
            java.lang.reflect.Type _type = java.lang.Void.class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, java.lang.Void>() {
                  @Override
                  public java.lang.Void apply(Object result) {
                    return (java.lang.Void) result;
                  }
                });
          }
        };

    return this.server.download(_ctx, _call, part, _stream);
  }

  /**
   * DownloadUrl returns a transient URL from which the binary
   * identified by the object name suffix can be downloaded using the
   * HTTP protocol. If not all parts of the binary have been uploaded,
   * the method returns an error.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.repository.BinaryServer.DownloadUrlOut>
      downloadUrl(io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.downloadUrl(_ctx, _call);
  }

  /**
   * Stat returns information describing the parts of the binary
   * identified by the object name suffix, and its RFC 2046 media type.
   * If the binary has not been created, the method returns an error.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.repository.BinaryServer.StatOut>
      stat(io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.stat(_ctx, _call);
  }

  /**
   * Upload opens a stream that can be used for uploading the given
   * part of the binary identified by the object name suffix. If the
   * binary has not been created, the method returns an error. If the
   * binary part has been uploaded, the method returns an error. If
   * the same binary part is being uploaded by another caller, the
   * method returns an error.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> upload(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call, final int part) {

    io.v.v23.vdl.ServerStream<java.lang.Void, byte[]> _stream =
        new io.v.v23.vdl.ServerStream<java.lang.Void, byte[]>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(
              java.lang.Void _item) {
            java.lang.reflect.Type _type = java.lang.Void.class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<byte[]> recv() {
            java.lang.reflect.Type _type = byte[].class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, byte[]>() {
                  @Override
                  public byte[] apply(Object result) {
                    return (byte[]) result;
                  }
                });
          }
        };

    return this.server.upload(_ctx, _call, part, _stream);
  }

  /**
   * GetPermissions returns the complete, current Permissions for an object. The
   * returned version can be passed to a subsequent call to SetPermissions for
   * optimistic concurrency control. A successful call to SetPermissions will
   * invalidate version, and the client must call GetPermissions again to get
   * the current version.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectServer.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
          throws io.v.v23.verror.VException {

    return this.wrapperObject.getPermissions(ctx, call);
  }

  /**
   * SetPermissions replaces the current Permissions for an object.  version
   * allows for optional, optimistic concurrency control.  If non-empty,
   * version's value must come from GetPermissions.  If any client has
   * successfully called SetPermissions in the meantime, the version will be
   * stale and SetPermissions will fail.  If empty, SetPermissions performs an
   * unconditional update.
   *<p>
   * Permissions objects are expected to be small.  It is up to the
   * implementation to define the exact limit, though it should probably be
   * around 100KB.  Large lists of principals can be represented concisely using
   * blessings.
   *<p>
   * There is some ambiguity when calling SetPermissions on a mount point.
   * Does it affect the mount itself or does it affect the service endpoint
   * that the mount points to?  The chosen behavior is that it affects the
   * service endpoint.  To modify the mount point's Permissions, use
   * ResolveToMountTable to get an endpoint and call SetPermissions on that.
   * This means that clients must know when a name refers to a mount point to
   * change its Permissions.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version)
      throws io.v.v23.verror.VException {

    return this.wrapperObject.setPermissions(ctx, call, perms, version);
  }
}
