// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: repository.vdl
package io.v.v23.services.repository;

/**
 * Binary can be used to store and retrieve vanadium application
 * binaries.
 *<p>
 * To create a binary, clients first invoke the Create() method that
 * specifies the number of parts the binary consists of. Clients then
 * uploads the individual parts through the Upload() method, which
 * identifies the part being uploaded. To resume an upload after a
 * failure, clients invoke the UploadStatus() method, which returns a
 * slice that identifies which parts are missing.
 *<p>
 * To download a binary, clients first invoke Stat(), which returns
 * information describing the binary, including the number of parts
 * the binary consists of. Clients then download the individual parts
 * through the Download() method, which identifies the part being
 * downloaded. Alternatively, clients can download the binary through
 * HTTP using a transient URL available through the DownloadUrl()
 * method.
 *<p>
 * To delete the binary, clients invoke the Delete() method.
 */
public interface BinaryClient extends io.v.v23.services.permissions.ObjectClient {

  /**
   * Create expresses the intent to create a binary identified by the
   * object name suffix consisting of the given number of parts. The
   * mediaInfo argument contains metadata for the binary. If the suffix
   * identifies a binary that has already been created, the method
   * returns an error.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      io.v.v23.context.VContext context,
      final int nparts,
      final io.v.v23.services.repository.MediaInfo mediaInfo);

  /**
   * Create expresses the intent to create a binary identified by the
   * object name suffix consisting of the given number of parts. The
   * mediaInfo argument contains metadata for the binary. If the suffix
   * identifies a binary that has already been created, the method
   * returns an error.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      io.v.v23.context.VContext context,
      final int nparts,
      final io.v.v23.services.repository.MediaInfo mediaInfo,
      io.v.v23.Options opts);

  /**
   * Create expresses the intent to create a binary identified by the
   * object name suffix consisting of the given number of parts. The
   * mediaInfo argument contains metadata for the binary. If the suffix
   * identifies a binary that has already been created, the method
   * returns an error.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      io.v.v23.context.VContext context,
      final int nparts,
      final io.v.v23.services.repository.MediaInfo mediaInfo,
      io.v.v23.options.RpcOptions opts);

  /**
   * Delete deletes the binary identified by the object name
   * suffix. If the binary that has not been created, the method
   * returns an error.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext context);

  /**
   * Delete deletes the binary identified by the object name
   * suffix. If the binary that has not been created, the method
   * returns an error.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * Delete deletes the binary identified by the object name
   * suffix. If the binary that has not been created, the method
   * returns an error.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * Download opens a stream that can used for downloading the given
   * part of the binary identified by the object name suffix. If the
   * binary part has not been uploaded, the method returns an
   * error. If the Delete() method is invoked when the Download()
   * method is in progress, the outcome the Download() method is
   * undefined.
   */
  io.v.v23.vdl.ClientRecvStream<byte[], java.lang.Void> download(
      io.v.v23.context.VContext context, final int part);

  /**
   * Download opens a stream that can used for downloading the given
   * part of the binary identified by the object name suffix. If the
   * binary part has not been uploaded, the method returns an
   * error. If the Delete() method is invoked when the Download()
   * method is in progress, the outcome the Download() method is
   * undefined.
   */
  @java.lang.Deprecated
  io.v.v23.vdl.ClientRecvStream<byte[], java.lang.Void> download(
      io.v.v23.context.VContext context, final int part, io.v.v23.Options opts);

  /**
   * Download opens a stream that can used for downloading the given
   * part of the binary identified by the object name suffix. If the
   * binary part has not been uploaded, the method returns an
   * error. If the Delete() method is invoked when the Download()
   * method is in progress, the outcome the Download() method is
   * undefined.
   */
  io.v.v23.vdl.ClientRecvStream<byte[], java.lang.Void> download(
      io.v.v23.context.VContext context, final int part, io.v.v23.options.RpcOptions opts);

  /**
   * Multi-return value for method {@link #downloadUrl}.
   */
  @io.v.v23.vdl.MultiReturn
  public static class DownloadUrlOut {

    public java.lang.String url;

    public long ttl;
  }

  /**
   * DownloadUrl returns a transient URL from which the binary
   * identified by the object name suffix can be downloaded using the
   * HTTP protocol. If not all parts of the binary have been uploaded,
   * the method returns an error.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.repository.BinaryClient.DownloadUrlOut>
      downloadUrl(io.v.v23.context.VContext context);

  /**
   * DownloadUrl returns a transient URL from which the binary
   * identified by the object name suffix can be downloaded using the
   * HTTP protocol. If not all parts of the binary have been uploaded,
   * the method returns an error.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.repository.BinaryClient.DownloadUrlOut>
      downloadUrl(io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * DownloadUrl returns a transient URL from which the binary
   * identified by the object name suffix can be downloaded using the
   * HTTP protocol. If not all parts of the binary have been uploaded,
   * the method returns an error.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.repository.BinaryClient.DownloadUrlOut>
      downloadUrl(io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * Multi-return value for method {@link #stat}.
   */
  @io.v.v23.vdl.MultiReturn
  public static class StatOut {

    public java.util.List<io.v.v23.services.binary.PartInfo> parts;

    public io.v.v23.services.repository.MediaInfo mediaInfo;
  }

  /**
   * Stat returns information describing the parts of the binary
   * identified by the object name suffix, and its RFC 2046 media type.
   * If the binary has not been created, the method returns an error.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.repository.BinaryClient.StatOut>
      stat(io.v.v23.context.VContext context);

  /**
   * Stat returns information describing the parts of the binary
   * identified by the object name suffix, and its RFC 2046 media type.
   * If the binary has not been created, the method returns an error.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.repository.BinaryClient.StatOut>
      stat(io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * Stat returns information describing the parts of the binary
   * identified by the object name suffix, and its RFC 2046 media type.
   * If the binary has not been created, the method returns an error.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.repository.BinaryClient.StatOut>
      stat(io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * Upload opens a stream that can be used for uploading the given
   * part of the binary identified by the object name suffix. If the
   * binary has not been created, the method returns an error. If the
   * binary part has been uploaded, the method returns an error. If
   * the same binary part is being uploaded by another caller, the
   * method returns an error.
   */
  io.v.v23.vdl.ClientSendStream<byte[], java.lang.Void> upload(
      io.v.v23.context.VContext context, final int part);

  /**
   * Upload opens a stream that can be used for uploading the given
   * part of the binary identified by the object name suffix. If the
   * binary has not been created, the method returns an error. If the
   * binary part has been uploaded, the method returns an error. If
   * the same binary part is being uploaded by another caller, the
   * method returns an error.
   */
  @java.lang.Deprecated
  io.v.v23.vdl.ClientSendStream<byte[], java.lang.Void> upload(
      io.v.v23.context.VContext context, final int part, io.v.v23.Options opts);

  /**
   * Upload opens a stream that can be used for uploading the given
   * part of the binary identified by the object name suffix. If the
   * binary has not been created, the method returns an error. If the
   * binary part has been uploaded, the method returns an error. If
   * the same binary part is being uploaded by another caller, the
   * method returns an error.
   */
  io.v.v23.vdl.ClientSendStream<byte[], java.lang.Void> upload(
      io.v.v23.context.VContext context, final int part, io.v.v23.options.RpcOptions opts);
}
