// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  repository.vdl
package io.v.v23.services.repository;

/**
 * Wrapper for {@link ApplicationServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class ApplicationServerWrapper {
  private final io.v.v23.services.repository.ApplicationServer server;

  private final io.v.v23.services.permissions.ObjectServerWrapper wrapperObject;

  private final io.v.v23.services.tidyable.TidyableServerWrapper wrapperTidyable;

  /**
   * Creates a new {@link ApplicationServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public ApplicationServerWrapper(io.v.v23.services.repository.ApplicationServer server) {
    this.server = server;

    this.wrapperObject = new io.v.v23.services.permissions.ObjectServerWrapper(server);

    this.wrapperTidyable = new io.v.v23.services.tidyable.TidyableServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<java.lang.String>>() {}.getType())));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.application.Envelope.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "match",
              "// Match checks if any of the given profiles contains an application"
                  + "// envelope for the given application version (specified through the"
                  + "// object name suffix) and if so, returns this envelope. If multiple"
                  + "// profile matches are possible, the method returns the first"
                  + "// matching profile, respecting the order of the input argument."
                  + "//"
                  + "// If the version is not specified in the suffix, the envelope"
                  + "// corresponding to the latest version that matches any of the given"
                  + "// profiles is returned.  If several profiles match this version, the"
                  + "// envelope for the first matching profile is returned, respecting the"
                  + "// order of the input argument."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Application",
        "io.v.v23.services.repository",
        "// Application provides access to application envelopes. An"
            + "// application envelope is identified by an application name and an"
            + "// application version, which are specified through the object name,"
            + "// and a profile name, which is specified using a method argument."
            + "//"
            + "// Example:"
            + "// /apps/search/v1.Match([]string{\"base\", \"media\"})"
            + "//   returns an application envelope that can be used for downloading"
            + "//   and executing the \"search\" application, version \"v1\", runnable"
            + "//   on either the \"base\" or \"media\" profile."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("match".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"match\": %s", e.getMessage()));
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperObject.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperTidyable.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  /**
   * Match checks if any of the given profiles contains an application
   * envelope for the given application version (specified through the
   * object name suffix) and if so, returns this envelope. If multiple
   * profile matches are possible, the method returns the first
   * matching profile, respecting the order of the input argument.
   *<p>
   * If the version is not specified in the suffix, the envelope
   * corresponding to the latest version that matches any of the given
   * profiles is returned.  If several profiles match this version, the
   * envelope for the first matching profile is returned, respecting the
   * order of the input argument.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.application.Envelope>
      match(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final java.util.List<java.lang.String> profiles) {

    return this.server.match(_ctx, _call, profiles);
  }

  /**
   * GetPermissions returns the complete, current Permissions for an object. The
   * returned version can be passed to a subsequent call to SetPermissions for
   * optimistic concurrency control. A successful call to SetPermissions will
   * invalidate version, and the client must call GetPermissions again to get
   * the current version.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectServer.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
          throws io.v.v23.verror.VException {

    return this.wrapperObject.getPermissions(ctx, call);
  }

  /**
   * SetPermissions replaces the current Permissions for an object.  version
   * allows for optional, optimistic concurrency control.  If non-empty,
   * version's value must come from GetPermissions.  If any client has
   * successfully called SetPermissions in the meantime, the version will be
   * stale and SetPermissions will fail.  If empty, SetPermissions performs an
   * unconditional update.
   *<p>
   * Permissions objects are expected to be small.  It is up to the
   * implementation to define the exact limit, though it should probably be
   * around 100KB.  Large lists of principals can be represented concisely using
   * blessings.
   *<p>
   * There is some ambiguity when calling SetPermissions on a mount point.
   * Does it affect the mount itself or does it affect the service endpoint
   * that the mount points to?  The chosen behavior is that it affects the
   * service endpoint.  To modify the mount point's Permissions, use
   * ResolveToMountTable to get an endpoint and call SetPermissions on that.
   * This means that clients must know when a name refers to a mount point to
   * change its Permissions.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version)
      throws io.v.v23.verror.VException {

    return this.wrapperObject.setPermissions(ctx, call, perms, version);
  }

  /**
   * Request the implementing service to perform regularly scheduled cleanup
   *  actions such as shrinking caches or rolling logs immediately.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> tidyNow(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperTidyable.tidyNow(ctx, call);
  }
}
