// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: repository.vdl
package io.v.v23.services.repository;

/**
 * Application provides access to application envelopes. An
 * application envelope is identified by an application name and an
 * application version, which are specified through the object name,
 * and a profile name, which is specified using a method argument.
 *<p>
 * Example:
 * /apps/search/v1.Match([]string{"base", "media"})
 *   returns an application envelope that can be used for downloading
 *   and executing the "search" application, version "v1", runnable
 *   on either the "base" or "media" profile.
 */
@io.v.v23.vdl.VServer(serverWrapper = io.v.v23.services.repository.ApplicationServerWrapper.class)
public interface ApplicationServer
    extends io.v.v23.services.permissions.ObjectServer, io.v.v23.services.tidyable.TidyableServer {

  /**
   * Match checks if any of the given profiles contains an application
   * envelope for the given application version (specified through the
   * object name suffix) and if so, returns this envelope. If multiple
   * profile matches are possible, the method returns the first
   * matching profile, respecting the order of the input argument.
   *<p>
   * If the version is not specified in the suffix, the envelope
   * corresponding to the latest version that matches any of the given
   * profiles is returned.  If several profiles match this version, the
   * envelope for the first matching profile is returned, respecting the
   * order of the input argument.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.application.Envelope> match(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final java.util.List<java.lang.String> profiles);
}
