// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  repository.vdl
package io.v.v23.services.repository;

/**
 * Implementation of the {@link ApplicationClient} interface.
 */
final class ApplicationClientImpl implements io.v.v23.services.repository.ApplicationClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  private final io.v.v23.services.permissions.ObjectClient implObject;

  private final io.v.v23.services.tidyable.TidyableClient implTidyable;

  /**
   * Creates a new instance of {@link ApplicationClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public ApplicationClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implObject =
          io.v.v23.services.permissions.ObjectClientFactory.getObjectClient(vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implTidyable =
          io.v.v23.services.tidyable.TidyableClientFactory.getTidyableClient(vName, opts);
    }
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface ApplicationClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.application.Envelope>
      match(io.v.v23.context.VContext _context, final java.util.List<java.lang.String> profiles) {
    return match(_context, profiles, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.application.Envelope>
      match(
          final io.v.v23.context.VContext _context,
          final java.util.List<java.lang.String> profiles,
          io.v.v23.Options _opts) {
    return match(_context, profiles, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.application.Envelope>
      match(
          final io.v.v23.context.VContext _context,
          final java.util.List<java.lang.String> profiles,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {profiles};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          new com.google.common.reflect.TypeToken<java.util.List<java.lang.String>>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "match", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.services.application.Envelope>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.v23.services.application.Envelope>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.services.application.Envelope.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.v23.services.application.Envelope>() {
                      @Override
                      public io.v.v23.services.application.Envelope apply(Object[] _results) {

                        return (io.v.v23.services.application.Envelope) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context) {

    return this.implObject.getPermissions(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implObject.getPermissions(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implObject.getPermissions(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version) {

    return this.implObject.setPermissions(_context, perms, version);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version,
      io.v.v23.Options _opts) {

    return this.implObject.setPermissions(_context, perms, version, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version,
      io.v.v23.options.RpcOptions _opts) {

    return this.implObject.setPermissions(_context, perms, version, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> tidyNow(
      io.v.v23.context.VContext _context) {

    return this.implTidyable.tidyNow(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> tidyNow(
      io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implTidyable.tidyNow(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> tidyNow(
      io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implTidyable.tidyNow(_context, _opts);
  }
}
