// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  pprof.vdl
package io.v.v23.services.pprof;

/**
 * Wrapper for {@link PProfServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class PProfServerWrapper {
  private final io.v.v23.services.pprof.PProfServer server;

  /**
   * Creates a new {@link PProfServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public PProfServerWrapper(io.v.v23.services.pprof.PProfServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<java.lang.String>>() {}.getType())));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "cmdLine",
              "// CmdLine returns the command-line arguments of the server, including"
                  + "// the name of the executable."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<java.lang.String>>() {}.getType())));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "profiles",
              "// Profiles returns the list of available profiles." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "profile",
              "// Profile streams the requested profile. The debug parameter enables"
                  + "// additional output. Passing debug=0 includes only the hexadecimal"
                  + "// addresses that pprof needs. Passing debug=1 adds comments translating"
                  + "// addresses to function names and line numbers, so that a programmer"
                  + "// can read the profile without tools."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "cpuProfile",
              "// CpuProfile enables CPU profiling for the requested duration and"
                  + "// streams the profile data."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<io.v.v23.vdl.VdlUint64>>() {}.getType())));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<java.lang.String>>() {}.getType())));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "symbol",
              "// Symbol looks up the program counters and returns their respective"
                  + "// function names."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "PProf", "io.v.v23.services.pprof", "", embeds, methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("cmdLine".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"cmdLine\": %s", e.getMessage()));
      }
    }

    if ("cpuProfile".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"cpuProfile\": %s", e.getMessage()));
      }
    }

    if ("profile".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"profile\": %s", e.getMessage()));
      }
    }

    if ("profiles".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"profiles\": %s", e.getMessage()));
      }
    }

    if ("symbol".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"symbol\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * CmdLine returns the command-line arguments of the server, including
   * the name of the executable.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.String>>
      cmdLine(io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.cmdLine(_ctx, _call);
  }

  /**
   * Profiles returns the list of available profiles.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.String>>
      profiles(io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.profiles(_ctx, _call);
  }

  /**
   * Profile streams the requested profile. The debug parameter enables
   * additional output. Passing debug=0 includes only the hexadecimal
   * addresses that pprof needs. Passing debug=1 adds comments translating
   * addresses to function names and line numbers, so that a programmer
   * can read the profile without tools.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> profile(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final java.lang.String name,
      final int debug) {

    io.v.v23.vdl.ServerStream<byte[], java.lang.Void> _stream =
        new io.v.v23.vdl.ServerStream<byte[], java.lang.Void>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(byte[] _item) {
            java.lang.reflect.Type _type = byte[].class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> recv() {
            java.lang.reflect.Type _type = java.lang.Void.class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, java.lang.Void>() {
                  @Override
                  public java.lang.Void apply(Object result) {
                    return (java.lang.Void) result;
                  }
                });
          }
        };

    return this.server.profile(_ctx, _call, name, debug, _stream);
  }

  /**
   * CpuProfile enables CPU profiling for the requested duration and
   * streams the profile data.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> cpuProfile(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final int seconds) {

    io.v.v23.vdl.ServerStream<byte[], java.lang.Void> _stream =
        new io.v.v23.vdl.ServerStream<byte[], java.lang.Void>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(byte[] _item) {
            java.lang.reflect.Type _type = byte[].class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> recv() {
            java.lang.reflect.Type _type = java.lang.Void.class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, java.lang.Void>() {
                  @Override
                  public java.lang.Void apply(Object result) {
                    return (java.lang.Void) result;
                  }
                });
          }
        };

    return this.server.cpuProfile(_ctx, _call, seconds, _stream);
  }

  /**
   * Symbol looks up the program counters and returns their respective
   * function names.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.String>>
      symbol(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final java.util.List<io.v.v23.vdl.VdlUint64> programCounters) {

    return this.server.symbol(_ctx, _call, programCounters);
  }
}
