// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.v23.services.permissions;

/**
 * Wrapper for {@link ObjectServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class ObjectServerWrapper {
  private final io.v.v23.services.permissions.ObjectServer server;

  /**
   * Creates a new {@link ObjectServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public ObjectServerWrapper(io.v.v23.services.permissions.ObjectServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.v23.security.access.Permissions>() {}.getType())));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "setPermissions",
              "// SetPermissions replaces the current Permissions for an object.  version"
                  + "// allows for optional, optimistic concurrency control.  If non-empty,"
                  + "// version's value must come from GetPermissions.  If any client has"
                  + "// successfully called SetPermissions in the meantime, the version will be"
                  + "// stale and SetPermissions will fail.  If empty, SetPermissions performs an"
                  + "// unconditional update."
                  + "//"
                  + "// Permissions objects are expected to be small.  It is up to the"
                  + "// implementation to define the exact limit, though it should probably be"
                  + "// around 100KB.  Large lists of principals can be represented concisely using"
                  + "// blessings."
                  + "//"
                  + "// There is some ambiguity when calling SetPermissions on a mount point."
                  + "// Does it affect the mount itself or does it affect the service endpoint"
                  + "// that the mount points to?  The chosen behavior is that it affects the"
                  + "// service endpoint.  To modify the mount point's Permissions, use"
                  + "// ResolveToMountTable to get an endpoint and call SetPermissions on that."
                  + "// This means that clients must know when a name refers to a mount point to"
                  + "// change its Permissions."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.v23.security.access.Permissions>() {}.getType())));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "getPermissions",
              "// GetPermissions returns the complete, current Permissions for an object. The"
                  + "// returned version can be passed to a subsequent call to SetPermissions for"
                  + "// optimistic concurrency control. A successful call to SetPermissions will"
                  + "// invalidate version, and the client must call GetPermissions again to get"
                  + "// the current version."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Object",
        "io.v.v23.services.permissions",
        "// Object provides access control for Vanadium objects."
            + "//"
            + "// Vanadium services implementing dynamic access control would typically embed"
            + "// this interface and tag additional methods defined by the service with one of"
            + "// Admin, Read, Write, Resolve etc. For example, the VDL definition of the"
            + "// object would be:"
            + "//"
            + "//   package mypackage"
            + "//"
            + "//   import \"v.io/v23/security/access\""
            + "//   import \"v.io/v23/services/permissions\""
            + "//"
            + "//   type MyObject interface {"
            + "//     permissions.Object"
            + "//     MyRead() (string, error) {access.Read}"
            + "//     MyWrite(string) error    {access.Write}"
            + "//   }"
            + "//"
            + "// If the set of pre-defined tags is insufficient, services may define their"
            + "// own tag type and annotate all methods with this new type."
            + "//"
            + "// Instead of embedding this Object interface, define SetPermissions and"
            + "// GetPermissions in their own interface. Authorization policies will typically"
            + "// respect annotations of a single type. For example, the VDL definition of an"
            + "// object would be:"
            + "//"
            + "//  package mypackage"
            + "//"
            + "//  import \"v.io/v23/security/access\""
            + "//"
            + "//  type MyTag string"
            + "//"
            + "//  const ("
            + "//    Blue = MyTag(\"Blue\")"
            + "//    Red  = MyTag(\"Red\")"
            + "//  )"
            + "//"
            + "//  type MyObject interface {"
            + "//    MyMethod() (string, error) {Blue}"
            + "//"
            + "//    // Allow clients to change access via the access.Object interface:"
            + "//    SetPermissions(perms access.Permissions, version string) error         {Red}"
            + "//    GetPermissions() (perms access.Permissions, version string, err error) {Blue}"
            + "//  }"
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("getPermissions".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"getPermissions\": %s", e.getMessage()));
      }
    }

    if ("setPermissions".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"setPermissions\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * SetPermissions replaces the current Permissions for an object.  version
   * allows for optional, optimistic concurrency control.  If non-empty,
   * version's value must come from GetPermissions.  If any client has
   * successfully called SetPermissions in the meantime, the version will be
   * stale and SetPermissions will fail.  If empty, SetPermissions performs an
   * unconditional update.
   *<p>
   * Permissions objects are expected to be small.  It is up to the
   * implementation to define the exact limit, though it should probably be
   * around 100KB.  Large lists of principals can be represented concisely using
   * blessings.
   *<p>
   * There is some ambiguity when calling SetPermissions on a mount point.
   * Does it affect the mount itself or does it affect the service endpoint
   * that the mount points to?  The chosen behavior is that it affects the
   * service endpoint.  To modify the mount point's Permissions, use
   * ResolveToMountTable to get an endpoint and call SetPermissions on that.
   * This means that clients must know when a name refers to a mount point to
   * change its Permissions.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version) {

    return this.server.setPermissions(_ctx, _call, perms, version);
  }

  /**
   * GetPermissions returns the complete, current Permissions for an object. The
   * returned version can be passed to a subsequent call to SetPermissions for
   * optimistic concurrency control. A successful call to SetPermissions will
   * invalidate version, and the client must call GetPermissions again to get
   * the current version.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectServer.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.getPermissions(_ctx, _call);
  }
}
