// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.v23.services.mounttable;

/**
 * Wrapper for {@link MountTableServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class MountTableServerWrapper {
  private final io.v.v23.services.mounttable.MountTableServer server;

  private final io.v.v23.services.permissions.ObjectServerWrapper wrapperObject;

  /**
   * Creates a new {@link MountTableServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public MountTableServerWrapper(io.v.v23.services.mounttable.MountTableServer server) {
    this.server = server;

    this.wrapperObject = new io.v.v23.services.permissions.ObjectServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlUint32.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.naming.MountFlag.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "mount",
              "// Mount Server (a global name) onto the receiver."
                  + "//"
                  + "// Subsequent mounts add to the servers mounted there.  The multiple"
                  + "// servers are considered equivalent and are meant solely for"
                  + "// availability, i.e., no load balancing is guaranteed."
                  + "//"
                  + "// The ttl is the number of seconds the mount is to last unless refreshed by"
                  + "// another mount of the same server.  A ttl of 0 represents an infinite"
                  + "// duration.  A server with an expired ttl should never appear in the results"
                  + "// nor affect the operation of any MountTable method, and should act as if it"
                  + "// was never present as far as the interface is concerned."
                  + "//"
                  + "// The flags represent a bit mask of options."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "unmount",
              "// Unmount removes server from the receiver.  If server is empty, remove all"
                  + "// servers mounted there.  Returns a non-nil error iff server remains mounted"
                  + "// at the mount point."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Boolean.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "delete",
              "// Delete removes the receiver.  If the receiver has children, it will not"
                  + "// be removed unless deleteSubtree is true in which case the whole subtree is"
                  + "// removed."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.naming.MountEntry.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "resolveStep",
              "// ResolveStep takes the next step in resolving a name.  Returns the next"
                  + "// servers to query and the suffix at those servers."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "MountTable",
        "io.v.v23.services.mounttable",
        "// MountTable defines the interface to talk to a mounttable."
            + "//"
            + "// In all methods of MountTable, the receiver is the name bound to."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("delete".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"delete\": %s", e.getMessage()));
      }
    }

    if ("mount".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"mount\": %s", e.getMessage()));
      }
    }

    if ("resolveStep".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"resolveStep\": %s", e.getMessage()));
      }
    }

    if ("unmount".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"unmount\": %s", e.getMessage()));
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperObject.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  /**
   * Mount Server (a global name) onto the receiver.
   *<p>
   * Subsequent mounts add to the servers mounted there.  The multiple
   * servers are considered equivalent and are meant solely for
   * availability, i.e., no load balancing is guaranteed.
   *<p>
   * The ttl is the number of seconds the mount is to last unless refreshed by
   * another mount of the same server.  A ttl of 0 represents an infinite
   * duration.  A server with an expired ttl should never appear in the results
   * nor affect the operation of any MountTable method, and should act as if it
   * was never present as far as the interface is concerned.
   *<p>
   * The flags represent a bit mask of options.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> mount(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final java.lang.String server,
      final io.v.v23.vdl.VdlUint32 ttl,
      final io.v.v23.naming.MountFlag flags) {

    return this.server.mount(_ctx, _call, server, ttl, flags);
  }

  /**
   * Unmount removes server from the receiver.  If server is empty, remove all
   * servers mounted there.  Returns a non-nil error iff server remains mounted
   * at the mount point.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> unmount(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final java.lang.String server) {

    return this.server.unmount(_ctx, _call, server);
  }

  /**
   * Delete removes the receiver.  If the receiver has children, it will not
   * be removed unless deleteSubtree is true in which case the whole subtree is
   * removed.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final boolean deleteSubtree) {

    return this.server.delete(_ctx, _call, deleteSubtree);
  }

  /**
   * ResolveStep takes the next step in resolving a name.  Returns the next
   * servers to query and the suffix at those servers.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.naming.MountEntry> resolveStep(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.resolveStep(_ctx, _call);
  }

  /**
   * GetPermissions returns the complete, current Permissions for an object. The
   * returned version can be passed to a subsequent call to SetPermissions for
   * optimistic concurrency control. A successful call to SetPermissions will
   * invalidate version, and the client must call GetPermissions again to get
   * the current version.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectServer.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
          throws io.v.v23.verror.VException {

    return this.wrapperObject.getPermissions(ctx, call);
  }

  /**
   * SetPermissions replaces the current Permissions for an object.  version
   * allows for optional, optimistic concurrency control.  If non-empty,
   * version's value must come from GetPermissions.  If any client has
   * successfully called SetPermissions in the meantime, the version will be
   * stale and SetPermissions will fail.  If empty, SetPermissions performs an
   * unconditional update.
   *<p>
   * Permissions objects are expected to be small.  It is up to the
   * implementation to define the exact limit, though it should probably be
   * around 100KB.  Large lists of principals can be represented concisely using
   * blessings.
   *<p>
   * There is some ambiguity when calling SetPermissions on a mount point.
   * Does it affect the mount itself or does it affect the service endpoint
   * that the mount points to?  The chosen behavior is that it affects the
   * service endpoint.  To modify the mount point's Permissions, use
   * ResolveToMountTable to get an endpoint and call SetPermissions on that.
   * This means that clients must know when a name refers to a mount point to
   * change its Permissions.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version)
      throws io.v.v23.verror.VException {

    return this.wrapperObject.setPermissions(ctx, call, perms, version);
  }
}
