// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.v23.services.mounttable;

/**
 * Implementation of the {@link MountTableClient} interface.
 */
final class MountTableClientImpl implements io.v.v23.services.mounttable.MountTableClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  private final io.v.v23.services.permissions.ObjectClient implObject;

  /**
   * Creates a new instance of {@link MountTableClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public MountTableClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implObject =
          io.v.v23.services.permissions.ObjectClientFactory.getObjectClient(vName, opts);
    }
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface MountTableClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> mount(
      io.v.v23.context.VContext _context,
      final java.lang.String server,
      final io.v.v23.vdl.VdlUint32 ttl,
      final io.v.v23.naming.MountFlag flags) {
    return mount(_context, server, ttl, flags, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> mount(
      final io.v.v23.context.VContext _context,
      final java.lang.String server,
      final io.v.v23.vdl.VdlUint32 ttl,
      final io.v.v23.naming.MountFlag flags,
      io.v.v23.Options _opts) {
    return mount(_context, server, ttl, flags, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> mount(
      final io.v.v23.context.VContext _context,
      final java.lang.String server,
      final io.v.v23.vdl.VdlUint32 ttl,
      final io.v.v23.naming.MountFlag flags,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {server, ttl, flags};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          java.lang.String.class, io.v.v23.vdl.VdlUint32.class, io.v.v23.naming.MountFlag.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "mount", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> unmount(
      io.v.v23.context.VContext _context, final java.lang.String server) {
    return unmount(_context, server, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> unmount(
      final io.v.v23.context.VContext _context,
      final java.lang.String server,
      io.v.v23.Options _opts) {
    return unmount(_context, server, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> unmount(
      final io.v.v23.context.VContext _context,
      final java.lang.String server,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {server};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {java.lang.String.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "unmount", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext _context, final boolean deleteSubtree) {
    return delete(_context, deleteSubtree, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      final io.v.v23.context.VContext _context,
      final boolean deleteSubtree,
      io.v.v23.Options _opts) {
    return delete(_context, deleteSubtree, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      final io.v.v23.context.VContext _context,
      final boolean deleteSubtree,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {deleteSubtree};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {java.lang.Boolean.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "delete", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.naming.MountEntry> resolveStep(
      io.v.v23.context.VContext _context) {
    return resolveStep(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.naming.MountEntry> resolveStep(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return resolveStep(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.naming.MountEntry> resolveStep(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "resolveStep", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.naming.MountEntry>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<io.v.v23.naming.MountEntry>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.naming.MountEntry.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], io.v.v23.naming.MountEntry>() {
                      @Override
                      public io.v.v23.naming.MountEntry apply(Object[] _results) {

                        return (io.v.v23.naming.MountEntry) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context) {

    return this.implObject.getPermissions(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implObject.getPermissions(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implObject.getPermissions(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version) {

    return this.implObject.setPermissions(_context, perms, version);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version,
      io.v.v23.Options _opts) {

    return this.implObject.setPermissions(_context, perms, version, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version,
      io.v.v23.options.RpcOptions _opts) {

    return this.implObject.setPermissions(_context, perms, version, _opts);
  }
}
