// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: service.vdl
package io.v.v23.services.mounttable;

/**
 * MountTable defines the interface to talk to a mounttable.
 *<p>
 * In all methods of MountTable, the receiver is the name bound to.
 */
public interface MountTableClient extends io.v.v23.services.permissions.ObjectClient {

  /**
   * Mount Server (a global name) onto the receiver.
   *<p>
   * Subsequent mounts add to the servers mounted there.  The multiple
   * servers are considered equivalent and are meant solely for
   * availability, i.e., no load balancing is guaranteed.
   *<p>
   * The ttl is the number of seconds the mount is to last unless refreshed by
   * another mount of the same server.  A ttl of 0 represents an infinite
   * duration.  A server with an expired ttl should never appear in the results
   * nor affect the operation of any MountTable method, and should act as if it
   * was never present as far as the interface is concerned.
   *<p>
   * The flags represent a bit mask of options.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> mount(
      io.v.v23.context.VContext context,
      final java.lang.String server,
      final io.v.v23.vdl.VdlUint32 ttl,
      final io.v.v23.naming.MountFlag flags);

  /**
   * Mount Server (a global name) onto the receiver.
   *<p>
   * Subsequent mounts add to the servers mounted there.  The multiple
   * servers are considered equivalent and are meant solely for
   * availability, i.e., no load balancing is guaranteed.
   *<p>
   * The ttl is the number of seconds the mount is to last unless refreshed by
   * another mount of the same server.  A ttl of 0 represents an infinite
   * duration.  A server with an expired ttl should never appear in the results
   * nor affect the operation of any MountTable method, and should act as if it
   * was never present as far as the interface is concerned.
   *<p>
   * The flags represent a bit mask of options.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> mount(
      io.v.v23.context.VContext context,
      final java.lang.String server,
      final io.v.v23.vdl.VdlUint32 ttl,
      final io.v.v23.naming.MountFlag flags,
      io.v.v23.Options opts);

  /**
   * Mount Server (a global name) onto the receiver.
   *<p>
   * Subsequent mounts add to the servers mounted there.  The multiple
   * servers are considered equivalent and are meant solely for
   * availability, i.e., no load balancing is guaranteed.
   *<p>
   * The ttl is the number of seconds the mount is to last unless refreshed by
   * another mount of the same server.  A ttl of 0 represents an infinite
   * duration.  A server with an expired ttl should never appear in the results
   * nor affect the operation of any MountTable method, and should act as if it
   * was never present as far as the interface is concerned.
   *<p>
   * The flags represent a bit mask of options.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> mount(
      io.v.v23.context.VContext context,
      final java.lang.String server,
      final io.v.v23.vdl.VdlUint32 ttl,
      final io.v.v23.naming.MountFlag flags,
      io.v.v23.options.RpcOptions opts);

  /**
   * Unmount removes server from the receiver.  If server is empty, remove all
   * servers mounted there.  Returns a non-nil error iff server remains mounted
   * at the mount point.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> unmount(
      io.v.v23.context.VContext context, final java.lang.String server);

  /**
   * Unmount removes server from the receiver.  If server is empty, remove all
   * servers mounted there.  Returns a non-nil error iff server remains mounted
   * at the mount point.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> unmount(
      io.v.v23.context.VContext context, final java.lang.String server, io.v.v23.Options opts);

  /**
   * Unmount removes server from the receiver.  If server is empty, remove all
   * servers mounted there.  Returns a non-nil error iff server remains mounted
   * at the mount point.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> unmount(
      io.v.v23.context.VContext context,
      final java.lang.String server,
      io.v.v23.options.RpcOptions opts);

  /**
   * Delete removes the receiver.  If the receiver has children, it will not
   * be removed unless deleteSubtree is true in which case the whole subtree is
   * removed.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext context, final boolean deleteSubtree);

  /**
   * Delete removes the receiver.  If the receiver has children, it will not
   * be removed unless deleteSubtree is true in which case the whole subtree is
   * removed.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext context, final boolean deleteSubtree, io.v.v23.Options opts);

  /**
   * Delete removes the receiver.  If the receiver has children, it will not
   * be removed unless deleteSubtree is true in which case the whole subtree is
   * removed.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext context,
      final boolean deleteSubtree,
      io.v.v23.options.RpcOptions opts);

  /**
   * ResolveStep takes the next step in resolving a name.  Returns the next
   * servers to query and the suffix at those servers.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.naming.MountEntry> resolveStep(
      io.v.v23.context.VContext context);

  /**
   * ResolveStep takes the next step in resolving a name.  Returns the next
   * servers to query and the suffix at those servers.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.naming.MountEntry> resolveStep(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * ResolveStep takes the next step in resolving a name.  Returns the next
   * servers to query and the suffix at those servers.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.naming.MountEntry> resolveStep(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);
}
