// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  logreader.vdl
package io.v.v23.services.logreader;

/**
 * Wrapper for {@link LogFileServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class LogFileServerWrapper {
  private final io.v.v23.services.logreader.LogFileServer server;

  /**
   * Creates a new {@link LogFileServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public LogFileServerWrapper(io.v.v23.services.logreader.LogFileServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Long.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "size",
              "// Size returns the number of bytes in the receiving object." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Long.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Boolean.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Long.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "readLog",
              "// ReadLog receives up to numEntries log entries starting at the"
                  + "// startPos offset (in bytes) in the receiving object. Each stream chunk"
                  + "// contains one log entry."
                  + "//"
                  + "// If follow is true, ReadLog will block and wait for more entries to"
                  + "// arrive when it reaches the end of the file."
                  + "//"
                  + "// ReadLog returns the position where it stopped reading, i.e. the"
                  + "// position where the next entry starts. This value can be used as"
                  + "// startPos for successive calls to ReadLog."
                  + "//"
                  + "// The returned error will be EndOfFile if and only if ReadLog reached the"
                  + "// end of the file and no log entries were returned."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "LogFile",
        "io.v.v23.services.logreader",
        "// LogFile can be used to access log files remotely." + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("readLog".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"readLog\": %s", e.getMessage()));
      }
    }

    if ("size".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"size\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * Size returns the number of bytes in the receiving object.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> size(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.size(_ctx, _call);
  }

  /**
   * ReadLog receives up to numEntries log entries starting at the
   * startPos offset (in bytes) in the receiving object. Each stream chunk
   * contains one log entry.
   *<p>
   * If follow is true, ReadLog will block and wait for more entries to
   * arrive when it reaches the end of the file.
   *<p>
   * ReadLog returns the position where it stopped reading, i.e. the
   * position where the next entry starts. This value can be used as
   * startPos for successive calls to ReadLog.
   *<p>
   * The returned error will be EndOfFile if and only if ReadLog reached the
   * end of the file and no log entries were returned.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> readLog(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final long startPos,
      final int numEntries,
      final boolean follow) {

    io.v.v23.vdl.ServerStream<io.v.v23.services.logreader.LogEntry, java.lang.Void> _stream =
        new io.v.v23.vdl.ServerStream<io.v.v23.services.logreader.LogEntry, java.lang.Void>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(
              io.v.v23.services.logreader.LogEntry _item) {
            java.lang.reflect.Type _type = io.v.v23.services.logreader.LogEntry.class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> recv() {
            java.lang.reflect.Type _type = java.lang.Void.class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, java.lang.Void>() {
                  @Override
                  public java.lang.Void apply(Object result) {
                    return (java.lang.Void) result;
                  }
                });
          }
        };

    return this.server.readLog(_ctx, _call, startPos, numEntries, follow, _stream);
  }
}
