// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  logreader.vdl
package io.v.v23.services.logreader;

/**
 * Implementation of the {@link LogFileClient} interface.
 */
final class LogFileClientImpl implements io.v.v23.services.logreader.LogFileClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  /**
   * Creates a new instance of {@link LogFileClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public LogFileClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface LogFileClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> size(
      io.v.v23.context.VContext _context) {
    return size(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> size(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return size(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> size(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "size", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Long>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Long.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Long>() {
                      @Override
                      public java.lang.Long apply(Object[] _results) {

                        return (java.lang.Long) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.logreader.LogEntry, java.lang.Long>
      readLog(
          io.v.v23.context.VContext _context,
          final long startPos,
          final int numEntries,
          final boolean follow) {
    return readLog(_context, startPos, numEntries, follow, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.logreader.LogEntry, java.lang.Long>
      readLog(
          final io.v.v23.context.VContext _context,
          final long startPos,
          final int numEntries,
          final boolean follow,
          io.v.v23.Options _opts) {
    return readLog(
        _context, startPos, numEntries, follow, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.v23.services.logreader.LogEntry, java.lang.Long>
      readLog(
          final io.v.v23.context.VContext _context,
          final long startPos,
          final int numEntries,
          final boolean follow,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {startPos, numEntries, follow};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          java.lang.Long.class, java.lang.Integer.class, java.lang.Boolean.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "readLog", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<
        java.lang.Void, io.v.v23.services.logreader.LogEntry, java.lang.Long>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(
          final java.lang.Void item) {
        final java.lang.reflect.Type type = java.lang.Void.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<
              io.v.v23.services.logreader.LogEntry>
          recv() {
        final java.lang.reflect.Type recvType = io.v.v23.services.logreader.LogEntry.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, io.v.v23.services.logreader.LogEntry>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<
                          io.v.v23.services.logreader.LogEntry>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<
                            Object, io.v.v23.services.logreader.LogEntry>() {
                          @Override
                          public io.v.v23.services.logreader.LogEntry apply(Object result) {
                            return (io.v.v23.services.logreader.LogEntry) result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> finish() {

        final java.lang.reflect.Type[] resultTypes =
            new java.lang.reflect.Type[] {
              java.lang.Long.class,
            };

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Long>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Long> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<Object[], java.lang.Long>() {
                          @Override
                          public java.lang.Long apply(Object[] _results) {

                            return (java.lang.Long) _results[0];
                          }
                        });
                  }
                }));
      }
    };
  }
}
