// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: logreader.vdl
package io.v.v23.services.logreader;

/**
 * LogFile can be used to access log files remotely.
 */
public interface LogFileClient {

  /**
   * Size returns the number of bytes in the receiving object.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Long> size(
      io.v.v23.context.VContext context);

  /**
   * Size returns the number of bytes in the receiving object.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Long> size(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * Size returns the number of bytes in the receiving object.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Long> size(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * ReadLog receives up to numEntries log entries starting at the
   * startPos offset (in bytes) in the receiving object. Each stream chunk
   * contains one log entry.
   *<p>
   * If follow is true, ReadLog will block and wait for more entries to
   * arrive when it reaches the end of the file.
   *<p>
   * ReadLog returns the position where it stopped reading, i.e. the
   * position where the next entry starts. This value can be used as
   * startPos for successive calls to ReadLog.
   *<p>
   * The returned error will be EndOfFile if and only if ReadLog reached the
   * end of the file and no log entries were returned.
   */
  io.v.v23.vdl.ClientRecvStream<io.v.v23.services.logreader.LogEntry, java.lang.Long> readLog(
      io.v.v23.context.VContext context,
      final long startPos,
      final int numEntries,
      final boolean follow);

  /**
   * ReadLog receives up to numEntries log entries starting at the
   * startPos offset (in bytes) in the receiving object. Each stream chunk
   * contains one log entry.
   *<p>
   * If follow is true, ReadLog will block and wait for more entries to
   * arrive when it reaches the end of the file.
   *<p>
   * ReadLog returns the position where it stopped reading, i.e. the
   * position where the next entry starts. This value can be used as
   * startPos for successive calls to ReadLog.
   *<p>
   * The returned error will be EndOfFile if and only if ReadLog reached the
   * end of the file and no log entries were returned.
   */
  @java.lang.Deprecated
  io.v.v23.vdl.ClientRecvStream<io.v.v23.services.logreader.LogEntry, java.lang.Long> readLog(
      io.v.v23.context.VContext context,
      final long startPos,
      final int numEntries,
      final boolean follow,
      io.v.v23.Options opts);

  /**
   * ReadLog receives up to numEntries log entries starting at the
   * startPos offset (in bytes) in the receiving object. Each stream chunk
   * contains one log entry.
   *<p>
   * If follow is true, ReadLog will block and wait for more entries to
   * arrive when it reaches the end of the file.
   *<p>
   * ReadLog returns the position where it stopped reading, i.e. the
   * position where the next entry starts. This value can be used as
   * startPos for successive calls to ReadLog.
   *<p>
   * The returned error will be EndOfFile if and only if ReadLog reached the
   * end of the file and no log entries were returned.
   */
  io.v.v23.vdl.ClientRecvStream<io.v.v23.services.logreader.LogEntry, java.lang.Long> readLog(
      io.v.v23.context.VContext context,
      final long startPos,
      final int numEntries,
      final boolean follow,
      io.v.v23.options.RpcOptions opts);
}
