// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: logreader.vdl
package io.v.v23.services.logreader;

/**
 * LogEntry is a log entry from a log file.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/logreader.LogEntry")
public class LogEntry extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Position", index = 0)
  private long position;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Line", index = 1)
  private java.lang.String line;

  /**
   * Vdl type for {@link LogEntry}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(LogEntry.class);

  /**
   * Creates a new zero-value instance of {@link LogEntry}.
   */
  public LogEntry() {
    super(VDL_TYPE);

    this.position = 0L;

    this.line = "";
  }

  /**
   * Creates a new instance of {@link LogEntry} with the provided field values.
   */
  public LogEntry(long position, java.lang.String line) {
    super(VDL_TYPE);

    this.position = position;

    this.line = line;
  }

  /**
   * The offset (in bytes) where this entry starts.
   */
  public long getPosition() {
    return this.position;
  }

  /**
   * The offset (in bytes) where this entry starts.
   */
  public void setPosition(long position) {
    this.position = position;
  }

  /**
   * The content of the log entry.
   */
  public java.lang.String getLine() {
    return this.line;
  }

  /**
   * The content of the log entry.
   */
  public void setLine(java.lang.String line) {
    this.line = line;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    LogEntry other = (LogEntry) obj;

    if (this.position != other.position) {
      return false;
    }

    if (this.line == null) {
      if (other.line != null) {
        return false;
      }
    } else if (!this.line.equals(other.line)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + java.lang.Long.valueOf(this.position).hashCode();

    result = prime * result + (this.line == null ? 0 : this.line.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "position:" + this.position;

    result += ", ";

    result += "line:" + this.line;

    return result + "}";
  }
}
